/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.BundleValidatorR3;
import org.jboss.osgi.framework.internal.BundleValidatorR4;
import org.jboss.osgi.framework.internal.FrameworkCoreServices;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

abstract class UserBundleInstalledService<B extends UserBundleState, R extends UserBundleRevision>
extends AbstractBundleService<B> {
    private final Deployment initialDeployment;
    private B bundleState;

    UserBundleInstalledService(FrameworkState frameworkState, Deployment deployment) {
        super(frameworkState);
        this.initialDeployment = deployment;
    }

    @Override
    public void start(StartContext context) throws StartException {
        BundleStoragePlugin.InternalStorageState storageState = null;
        try {
            Deployment dep = this.initialDeployment;
            Long bundleId = (Long)dep.getAttachment(Long.class);
            storageState = this.createStorageState(dep, bundleId);
            OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
            R brev = this.createBundleRevision(dep, metadata, storageState);
            brev.addAttachment(Long.class, (Object)bundleId);
            ServiceName serviceName = context.getController().getName().getParent();
            this.bundleState = this.createBundleState(brev, serviceName);
            dep.addAttachment(Bundle.class, this.bundleState);
            ((UserBundleState)((Object)this.bundleState)).initLazyActivation();
            this.validateBundle((UserBundleState)((Object)this.bundleState), metadata);
            this.processNativeCode((UserBundleState)((Object)this.bundleState), dep);
            this.createResolvedService(context.getChildTarget(), brev);
            this.addToEnvironment((UserBundleRevision)((Object)brev));
            ((AbstractBundleState)((Object)this.bundleState)).changeState(2, 0);
            ((AbstractBundleState)((Object)this.bundleState)).fireBundleEvent(1);
            FrameworkLogger.LOGGER.infoBundleInstalled((Bundle)this.bundleState);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
                storagePlugin.deleteStorageState(storageState);
            }
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        this.getBundleManager().uninstallBundle((UserBundleState)this.getBundleState(), 1);
    }

    abstract R createBundleRevision(Deployment var1, OSGiMetaData var2, BundleStoragePlugin.InternalStorageState var3) throws BundleException;

    abstract B createBundleState(R var1, ServiceName var2) throws BundleException;

    abstract void createResolvedService(ServiceTarget var1, R var2);

    BundleStoragePlugin.InternalStorageState createStorageState(Deployment dep, Long bundleId) throws BundleException {
        BundleStoragePlugin.InternalStorageState storageState = (BundleStoragePlugin.InternalStorageState)dep.getAttachment(StorageState.class);
        if (storageState == null) {
            String location = dep.getLocation();
            VirtualFile rootFile = dep.getRoot();
            try {
                BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
                Integer startlevel = dep.getStartLevel();
                if (startlevel == null) {
                    FrameworkCoreServices coreServices = this.getFrameworkState().getCoreServices();
                    startlevel = coreServices.getStartLevelPlugin().getInitialBundleStartLevel();
                }
                storageState = storagePlugin.createStorageState(bundleId, location, startlevel, rootFile);
                dep.addAttachment(StorageState.class, (Object)storageState);
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.cannotSetupStorage(ex, rootFile);
            }
        }
        return storageState;
    }

    @Override
    B getBundleState() {
        return this.bundleState;
    }

    private void validateBundle(UserBundleState userBundle, OSGiMetaData metadata) throws BundleException {
        if (metadata.getBundleManifestVersion() > 1) {
            new BundleValidatorR4().validateBundle(userBundle, metadata);
        } else {
            new BundleValidatorR3().validateBundle(userBundle, metadata);
        }
    }

    private void processNativeCode(UserBundleState userBundle, Deployment dep) {
        OSGiMetaData metadata = userBundle.getOSGiMetaData();
        if (metadata.getBundleNativeCode() != null) {
            FrameworkState frameworkState = userBundle.getFrameworkState();
            NativeCodePlugin nativeCodePlugin = frameworkState.getNativeCodePlugin();
            nativeCodePlugin.deployNativeCode(dep);
        }
    }

    private void addToEnvironment(UserBundleRevision userRev) {
        UserBundleState userBundle = userRev.getBundleState();
        if (userBundle.isSingleton()) {
            String symbolicName = this.getBundleState().getSymbolicName();
            for (XBundle bundle2 : this.getBundleManager().getBundles(symbolicName, null)) {
                AbstractBundleState bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
                if (bundleState == userBundle || !bundleState.isSingleton()) continue;
                FrameworkLogger.LOGGER.infoNoResolvableSingleton((Bundle)userBundle);
                return;
            }
        }
        FrameworkState frameworkState = userBundle.getFrameworkState();
        XEnvironment env = frameworkState.getEnvironment();
        env.installResources(new XResource[]{userRev});
    }
}

