/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.Module;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.EntriesProvider;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ModuleEntriesProvider;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;

abstract class UserBundleRevision
extends BundleStateRevision {
    private final Deployment deployment;
    private final List<RevisionContent> contentList;
    private final EntriesProvider entriesProvider;

    UserBundleRevision(FrameworkState frameworkState, Deployment dep, OSGiMetaData metadata, BundleStoragePlugin.InternalStorageState storageState) throws BundleException {
        super(frameworkState, metadata, storageState);
        this.deployment = dep;
        if (dep.getRoot() != null) {
            this.contentList = this.getBundleClassPath(dep.getRoot(), metadata, storageState);
            this.entriesProvider = this.getRootContent();
        } else {
            Module module = (Module)dep.getAttachment(Module.class);
            this.entriesProvider = new ModuleEntriesProvider(module);
            this.contentList = Collections.emptyList();
            this.addAttachment(Module.class, module);
        }
    }

    static UserBundleRevision assertBundleRevision(BundleRevision brev) {
        assert (brev instanceof UserBundleRevision) : "Not an UserBundleRevision: " + brev;
        return (UserBundleRevision)brev;
    }

    UserBundleState getBundleState() {
        return (UserBundleState)this.getBundle();
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    String getLocation() {
        return this.deployment.getLocation();
    }

    RevisionContent getRootContent() {
        return this.contentList.size() > 0 ? this.contentList.get(0) : null;
    }

    List<RevisionContent> getContentList() {
        return this.contentList;
    }

    RevisionContent getContentById(int contentId) {
        for (RevisionContent aux : this.contentList) {
            if (aux.getContentId() != contentId) continue;
            return aux;
        }
        return null;
    }

    @Override
    void close() {
        super.close();
        for (RevisionContent aux : this.contentList) {
            aux.close();
        }
    }

    public Enumeration<String> getEntryPaths(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntryPaths(path);
    }

    public URL getEntry(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntry(path);
    }

    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.findEntries(path, pattern, recurse);
    }

    private List<RevisionContent> getBundleClassPath(VirtualFile rootFile, OSGiMetaData metadata, StorageState storageState) {
        assert (rootFile != null) : "Null rootFile";
        long bundleId = storageState.getBundleId();
        if (metadata.getBundleClassPath() == null) {
            RevisionContent revContent = new RevisionContent(this, metadata, bundleId, 0, rootFile);
            return Collections.singletonList(revContent);
        }
        ArrayList<RevisionContent> rootList = new ArrayList<RevisionContent>();
        for (String path : metadata.getBundleClassPath()) {
            if (path.equals(".")) {
                RevisionContent revContent = new RevisionContent(this, metadata, bundleId, rootList.size(), rootFile);
                rootList.add(revContent);
                continue;
            }
            try {
                VirtualFile child = rootFile.getChild(path);
                if (child == null) continue;
                VirtualFile anotherRoot = AbstractVFS.toVirtualFile((URL)child.toURL());
                RevisionContent revContent = new RevisionContent(this, metadata, bundleId, rootList.size(), anotherRoot);
                rootList.add(revContent);
            }
            catch (IOException ex) {
                FrameworkLogger.LOGGER.errorCannotGetClassPathEntry(ex, path, (BundleRevision)this);
            }
        }
        return Collections.unmodifiableList(rootList);
    }
}

