/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DefaultBundleLifecycleHandler;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.ConstantsHelper;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

abstract class UserBundleState
extends AbstractBundleState {
    private final List<UserBundleRevision> revisions = new CopyOnWriteArrayList<UserBundleRevision>();
    private final ServiceName serviceName;
    private Dictionary<String, String> headersOnUninstall;

    UserBundleState(FrameworkState frameworkState, UserBundleRevision brev, ServiceName serviceName) {
        super(frameworkState, brev, brev.getStorageState().getBundleId());
        this.serviceName = serviceName;
        this.addBundleRevision(brev);
    }

    static UserBundleState assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof UserBundleState) : "Not an UserBundleState: " + bundle2;
        return (UserBundleState)((Object)bundle2);
    }

    public String getLocation() {
        return this.getBundleRevision().getLocation();
    }

    Deployment getDeployment() {
        return this.getBundleRevision().getDeployment();
    }

    RevisionContent getFirstContentRoot() {
        return this.getBundleRevision().getRootContent();
    }

    List<RevisionContent> getContentRoots() {
        return this.getBundleRevision().getContentList();
    }

    @Override
    boolean isSingleton() {
        return this.getOSGiMetaData().isSingleton();
    }

    abstract void initLazyActivation();

    abstract UserBundleRevision createUpdateRevision(Deployment var1, OSGiMetaData var2, BundleStoragePlugin.InternalStorageState var3) throws BundleException;

    @Override
    public <T> T adapt(Class<T> type) {
        Object result = super.adapt(type);
        if (result == null && type.isAssignableFrom(Deployment.class)) {
            result = this.getDeployment();
        }
        return result;
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.headersOnUninstall != null) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    @Override
    ServiceName getServiceName(int state) {
        if (state == 0) {
            return this.serviceName;
        }
        if (state == 2 || state == 4 || state == 32) {
            return this.serviceName.append(new String[]{ConstantsHelper.bundleState((int)state)});
        }
        return null;
    }

    @Override
    void addBundleRevision(BundleStateRevision rev) {
        super.addBundleRevision(rev);
        this.revisions.add(0, (UserBundleRevision)rev);
    }

    @Override
    public UserBundleRevision getBundleRevision() {
        return (UserBundleRevision)super.getBundleRevision();
    }

    public List<XBundleRevision> getAllBundleRevisions() {
        ArrayList<UserBundleRevision> result = new ArrayList<UserBundleRevision>(this.revisions);
        return Collections.unmodifiableList(result);
    }

    void clearOldRevisions() {
        UserBundleRevision rev = this.getBundleRevision();
        this.revisions.clear();
        this.revisions.add(rev);
    }

    @Override
    BundleStateRevision getBundleRevisionById(int revisionId) {
        for (UserBundleRevision rev : this.revisions) {
            if (rev.getRevisionId() != revisionId) continue;
            return rev;
        }
        return null;
    }

    boolean hasActiveWires() {
        BundleWiring wiring = this.getBundleRevision().getWiring();
        return wiring != null ? wiring.isInUse() : false;
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        int state;
        boolean restart = false;
        if (!(this.isFragment() || (state = this.getState()) != 32 && state != 8 && state != 16)) {
            this.stopInternal(1);
            if (state != 16) {
                restart = true;
            }
        }
        this.changeState(2, 64);
        try {
            this.createUpdateRevision(input);
        }
        catch (BundleException ex) {
            if (restart) {
                this.startInternal(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            BundleException be = new BundleException("Problem updating bundle");
            be.initCause((Throwable)ex);
            if (restart) {
                this.startInternal(1);
            }
            throw be;
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, 8);
        if (restart) {
            try {
                this.startInternal(1);
            }
            catch (BundleException e) {
                eventsPlugin.fireFrameworkEvent((Bundle)this, 2, e);
            }
        }
    }

    private void createUpdateRevision(InputStream input) throws Exception {
        VirtualFile rootFile = null;
        if (input == null) {
            String updateLocation = this.getOSGiMetaData().getHeader("Bundle-UpdateLocation");
            if (updateLocation != null) {
                URL updateURL = new URL(updateLocation);
                rootFile = AbstractVFS.toVirtualFile((URL)updateURL);
            } else {
                rootFile = this.getFirstContentRoot().getVirtualFile();
            }
        }
        if (rootFile == null && input != null) {
            rootFile = AbstractVFS.toVirtualFile((InputStream)input);
        }
        BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
        BundleStoragePlugin.InternalStorageState storageState = this.createStorageState(storagePlugin, this.getLocation(), rootFile);
        try {
            DeploymentFactoryPlugin deploymentPlugin = this.getFrameworkState().getDeploymentFactoryPlugin();
            Deployment dep = deploymentPlugin.createDeployment(storageState);
            OSGiMetaData metadata = deploymentPlugin.createOSGiMetaData(dep);
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
            dep.addAttachment(Bundle.class, (Object)this);
            UserBundleRevision updateRevision = this.createUpdateRevision(dep, metadata, storageState);
            this.addBundleRevision(updateRevision);
            XEnvironment env = this.getFrameworkState().getEnvironment();
            env.installResources(new XResource[]{updateRevision});
        }
        catch (BundleException ex) {
            storagePlugin.deleteStorageState(storageState);
            throw ex;
        }
        catch (RuntimeException ex) {
            storagePlugin.deleteStorageState(storageState);
            throw ex;
        }
    }

    private BundleStoragePlugin.InternalStorageState createStorageState(BundleStoragePlugin storagePlugin, String location, VirtualFile rootFile) throws BundleException {
        BundleStoragePlugin.InternalStorageState storageState;
        try {
            int startlevel = this.getCoreServices().getStartLevelPlugin().getInitialBundleStartLevel();
            storageState = storagePlugin.createStorageState(this.getBundleId(), location, startlevel, rootFile);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.cannotSetupStorage(ex, rootFile);
        }
        return storageState;
    }

    void refresh() throws BundleException {
        this.assertNotUninstalled();
        if (!this.isResolved()) {
            throw FrameworkMessages.MESSAGES.illegalStateRefreshUnresolvedBundle((Bundle)this);
        }
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        UserBundleRevision currentRev = this.getBundleRevision();
        for (XBundleRevision brev : this.getAllBundleRevisions()) {
            UserBundleRevision userRev = UserBundleRevision.assertBundleRevision((BundleRevision)brev);
            XEnvironment env = this.getFrameworkState().getEnvironment();
            if (currentRev != brev) {
                env.uninstallResources(new XResource[]{brev});
                userRev.close();
            }
            if (brev instanceof HostBundleRevision) {
                HostBundleRevision hostRev = (HostBundleRevision)brev;
                for (FragmentBundleRevision fragRev : hostRev.getAttachedFragments()) {
                    if (fragRev == fragRev.getBundle().getBundleRevision()) continue;
                    env.uninstallResources(new XResource[]{fragRev});
                    fragRev.close();
                }
            }
            ModuleIdentifier identifier = brev.getModuleIdentifier();
            moduleManager.removeModule(brev, identifier);
        }
        this.clearOldRevisions();
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, 64);
        currentRev.refreshRevision();
        this.changeState(2);
        this.getBundleManager().setServiceMode(this.getServiceName(4), ServiceController.Mode.NEVER);
    }

    @Override
    void uninstallInternal() throws BundleException {
        this.headersOnUninstall = this.getHeaders(null);
        BundleLifecyclePlugin lifecyclePlugin = this.getCoreServices().getBundleLifecyclePlugin();
        lifecyclePlugin.uninstall(this, DefaultBundleLifecycleHandler.INSTANCE);
    }

    void removeServices() {
        FrameworkLogger.LOGGER.debugf("Remove services for: %s", (Object)this);
        BundleManagerPlugin bundleManager = this.getBundleManager();
        bundleManager.setServiceMode(this.getServiceName(32), ServiceController.Mode.REMOVE);
        bundleManager.setServiceMode(this.getServiceName(4), ServiceController.Mode.REMOVE);
        bundleManager.setServiceMode(this.getServiceName(2), ServiceController.Mode.REMOVE);
    }
}

