/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.spi.BundleLock;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ModuleLoaderPlugin;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.startlevel.StartLevel;

public class AbstractBundleAdaptor
extends AbstractElement
implements XBundle {
    private final AtomicInteger bundleState = new AtomicInteger(4);
    private final BundleLock bundleLock = new BundleLock();
    private final BundleContext context;
    private final XBundleRevision brev;
    private final Module module;
    private StartLevelPlugin startLevelPlugin;
    private BundleActivator bundleActivator;
    private long lastModified;

    public AbstractBundleAdaptor(BundleContext context, Module module, XBundleRevision brev) {
        if (context == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("context");
        }
        if (module == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("module");
        }
        if (brev == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("brev");
        }
        this.context = context;
        this.module = module;
        this.brev = brev;
        this.lastModified = System.currentTimeMillis();
    }

    public long getBundleId() {
        Long bundleId = (Long)this.brev.getAttachment(Long.class);
        return bundleId != null ? bundleId : -1L;
    }

    public String getLocation() {
        String location = this.module.getIdentifier().getName();
        String slot = this.module.getIdentifier().getSlot();
        if (!slot.equals("main")) {
            location = location + ":" + slot;
        }
        return location;
    }

    public String getSymbolicName() {
        return this.module.getIdentifier().getName();
    }

    public String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public int getState() {
        return this.bundleState.get();
    }

    public Version getVersion() {
        String slot = this.module.getIdentifier().getSlot();
        try {
            return Version.parseVersion((String)slot);
        }
        catch (IllegalArgumentException ex) {
            return Version.emptyVersion;
        }
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.module.getClassLoader().loadClass(name);
    }

    public <T> T adapt(Class<T> type) {
        Module result = null;
        if (type == Module.class) {
            result = this.module;
        } else if (type == BundleRevision.class) {
            result = this.brev;
        }
        return (T)result;
    }

    public void start(int options) throws BundleException {
        this.aquireBundleLock(BundleLock.LockMethod.START);
        try {
            String activatorName;
            if (this.getState() == 32) {
                return;
            }
            if (!this.startLevelValidForStart()) {
                if ((options & 1) != 0) {
                    throw FrameworkMessages.MESSAGES.cannotStartBundleDueToStartLevel();
                }
                FrameworkLogger.LOGGER.debugf("Start level [%d] not valid for: %s", this.getStartLevel(), (Object)this);
                this.setPersistentlyStarted(true);
                return;
            }
            this.bundleState.set(8);
            OSGiMetaData metadata = (OSGiMetaData)this.brev.getAttachment(OSGiMetaData.class);
            String string = activatorName = metadata != null ? metadata.getBundleActivator() : null;
            if (this.bundleActivator == null && activatorName != null) {
                Object result = this.loadClass(activatorName).newInstance();
                if (result instanceof BundleActivator) {
                    this.bundleActivator = (BundleActivator)result;
                } else {
                    throw FrameworkMessages.MESSAGES.invalidBundleActivator(activatorName);
                }
            }
            if (this.bundleActivator != null) {
                this.bundleActivator.start(this.context);
            }
            this.setPersistentlyStarted(true);
            this.bundleState.set(32);
            FrameworkLogger.LOGGER.infoBundleStarted((Bundle)this);
        }
        catch (Throwable th) {
            this.bundleState.set(4);
            throw FrameworkMessages.MESSAGES.cannotStartBundle(th, (Bundle)this);
        }
        finally {
            this.releaseBundleLock(BundleLock.LockMethod.START);
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void stop(int options) throws BundleException {
        this.aquireBundleLock(BundleLock.LockMethod.STOP);
        try {
            if (this.getState() != 32) {
                return;
            }
            if ((options & 1) == 0) {
                this.setPersistentlyStarted(false);
            }
            if (this.bundleActivator != null) {
                this.bundleActivator.stop(this.context);
            }
            this.bundleState.set(4);
            FrameworkLogger.LOGGER.infoBundleStopped((Bundle)this);
        }
        catch (Throwable th) {
            throw FrameworkMessages.MESSAGES.cannotStopBundle(th, (Bundle)this);
        }
        finally {
            this.releaseBundleLock(BundleLock.LockMethod.STOP);
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void update(InputStream input) throws BundleException {
        throw FrameworkMessages.MESSAGES.unsupportedBundleOpertaion((Bundle)this);
    }

    public void update() throws BundleException {
        throw FrameworkMessages.MESSAGES.unsupportedBundleOpertaion((Bundle)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws BundleException {
        this.aquireBundleLock(BundleLock.LockMethod.UNINSTALL);
        try {
            XBundle sysbundle = (XBundle)this.context.getBundle();
            XEnvironment env = (XEnvironment)sysbundle.adapt(XEnvironment.class);
            env.uninstallResources(new XResource[]{this.getBundleRevision()});
            BundleManager bundleManager = (BundleManager)sysbundle.adapt(BundleManager.class);
            ServiceContainer serviceContainer = bundleManager.getServiceContainer();
            ServiceController service = serviceContainer.getRequiredService(IntegrationServices.MODULE_LOADER_PLUGIN);
            ModuleLoaderPlugin provider = (ModuleLoaderPlugin)service.getValue();
            provider.removeModule(this.brev, this.module.getIdentifier());
            this.bundleState.set(1);
        }
        finally {
            this.releaseBundleLock(BundleLock.LockMethod.UNINSTALL);
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String locale) {
        return new Hashtable();
    }

    public ServiceReference[] getRegisteredServices() {
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        return null;
    }

    public boolean hasPermission(Object permission) {
        return false;
    }

    public URL getResource(String name) {
        return this.getBundleRevision().getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getBundleRevision().getResources(name);
    }

    public Enumeration getEntryPaths(String path) {
        return this.getBundleRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getBundleRevision().getEntry(path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return this.getBundleRevision().findEntries(path, filePattern, recurse);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public Map getSignerCertificates(int signersType) {
        return Collections.emptyMap();
    }

    public boolean isResolved() {
        return true;
    }

    public boolean isFragment() {
        return this.getBundleRevision().isFragment();
    }

    public XBundleRevision getBundleRevision() {
        return this.brev;
    }

    public List<XBundleRevision> getAllBundleRevisions() {
        return Collections.singletonList(this.brev);
    }

    private boolean aquireBundleLock(BundleLock.LockMethod method) {
        return this.bundleLock.tryLock(this, method);
    }

    private void releaseBundleLock(BundleLock.LockMethod method) {
        this.bundleLock.unlock(this, method);
    }

    private int getStartLevel() {
        return this.getStartLevelPlugin().getBundleStartLevel((Bundle)this);
    }

    private void setPersistentlyStarted(boolean started) {
        this.getStartLevelPlugin().setBundlePersistentlyStarted(this, started);
    }

    private boolean startLevelValidForStart() {
        return this.getStartLevel() <= this.getStartLevelPlugin().getStartLevel();
    }

    private StartLevelPlugin getStartLevelPlugin() {
        if (this.startLevelPlugin == null) {
            ServiceReference sref = this.context.getServiceReference(StartLevel.class.getName());
            this.startLevelPlugin = (StartLevelPlugin)this.context.getService(sref);
        }
        return this.startLevelPlugin;
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBundle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XBundle other = (XBundle)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

