/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.spi.BootstrapBundlesComplete;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BootstrapBundlesActivate<T>
extends BootstrapBundlesService<T> {
    private final Set<ServiceName> resolvedServices;

    public BootstrapBundlesActivate(ServiceName baseName, Set<ServiceName> resolvedServices) {
        super(baseName, IntegrationServices.BootstrapPhase.ACTIVATE);
        this.resolvedServices = resolvedServices;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependencies(new ServiceName[]{this.getPreviousService()});
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer serviceRegistry = context.getController().getServiceContainer();
        ArrayList<XBundle> bundles = new ArrayList<XBundle>();
        for (ServiceName serviceName : this.resolvedServices) {
            ServiceController controller = serviceRegistry.getRequiredService(serviceName);
            bundles.add((XBundle)controller.getValue());
        }
        Collections.sort(bundles, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                return (int)(o1.getBundleId() - o2.getBundleId());
            }
        });
        for (XBundle bundle2 : bundles) {
            try {
                bundle2.start(2);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorCannotStartBundle(ex, (Bundle)bundle2);
            }
        }
        this.installCompleteService(context.getChildTarget());
    }

    protected ServiceController<T> installCompleteService(ServiceTarget serviceTarget) {
        return new BootstrapBundlesComplete(this.getServiceName().getParent()).install(serviceTarget, this.getServiceListener());
    }
}

