/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.spi.BootstrapBundlesResolve;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.BundleException;

public abstract class BootstrapBundlesInstall<T>
extends BootstrapBundlesService<T> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();

    public BootstrapBundlesInstall(ServiceName baseName) {
        super(baseName, IntegrationServices.BootstrapPhase.INSTALL);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    protected BundleManager getBundleManager() {
        return (BundleManager)this.injectedBundleManager.getValue();
    }

    protected void installBootstrapBundles(final ServiceTarget serviceTarget, final List<Deployment> deployments) {
        ServiceTracker<XBundle> installTracker = new ServiceTracker<XBundle>(){
            Set<ServiceName> installedServices = new HashSet<ServiceName>();

            @Override
            protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                return deployments.size() == trackedServices.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void serviceStarted(ServiceController<? extends XBundle> controller) {
                Set<ServiceName> set = this.installedServices;
                synchronized (set) {
                    this.installedServices.add(controller.getName());
                }
            }

            @Override
            protected void complete() {
                BootstrapBundlesInstall.this.installResolveService(serviceTarget, this.installedServices);
            }
        };
        BundleManager bundleManager = this.getBundleManager();
        for (Deployment dep : deployments) {
            try {
                bundleManager.installBundle(dep, (ServiceListener<XBundle>)installTracker);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, dep.getLocation());
            }
        }
        installTracker.checkAndComplete();
    }

    protected ServiceController<T> installResolveService(ServiceTarget serviceTarget, Set<ServiceName> installedServices) {
        return new BootstrapBundlesResolve(this.getServiceName().getParent(), installedServices).install(serviceTarget, this.getServiceListener());
    }
}

