/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.spi.BootstrapBundlesActivate;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.resolver.ResolutionException;

public class BootstrapBundlesResolve<T>
extends BootstrapBundlesService<T> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final Set<ServiceName> installedServices;

    public BootstrapBundlesResolve(ServiceName baseName, Set<ServiceName> installedServices) {
        super(baseName, IntegrationServices.BootstrapPhase.RESOLVE);
        this.installedServices = installedServices;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, this.injectedPackageAdmin);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependencies(new ServiceName[]{this.getPreviousService()});
    }

    protected BundleManager getBundleManager() {
        return (BundleManager)this.injectedBundleManager.getValue();
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer serviceRegistry = context.getController().getServiceContainer();
        int targetLevel = this.getBeginningStartLevel();
        HashMap<ServiceName, XBundle> resolvableServices = new HashMap<ServiceName, XBundle>();
        for (ServiceName serviceName : this.installedServices) {
            int bundleLevel;
            ServiceController controller = serviceRegistry.getRequiredService(serviceName);
            XBundle bundle2 = (XBundle)controller.getValue();
            Deployment dep = (Deployment)bundle2.adapt(Deployment.class);
            int n = bundleLevel = dep.getStartLevel() != null ? dep.getStartLevel() : 1;
            if (!dep.isAutoStart() || bundle2.isFragment() || bundleLevel > targetLevel) continue;
            resolvableServices.put(serviceName, bundle2);
        }
        if (IntegrationServices.BOOTSTRAP_BUNDLES.isParentOf(this.getServiceName())) {
            XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
            ArrayList<XBundleRevision> mandatory = new ArrayList<XBundleRevision>();
            for (XBundle bundle2 : resolvableServices.values()) {
                mandatory.add(bundle2.getBundleRevision());
            }
            XResolver resolver = (XResolver)this.injectedResolver.getValue();
            XResolveContext ctx = resolver.createResolveContext(env, mandatory, null);
            try {
                resolver.resolveAndApply(ctx);
            }
            catch (ResolutionException ex) {
                throw new StartException((Throwable)ex);
            }
        }
        if (IntegrationServices.PERSISTENT_BUNDLES.isParentOf(this.getServiceName())) {
            Bundle[] bundles = resolvableServices.values().toArray(new Bundle[resolvableServices.size()]);
            PackageAdmin packageAdmin = (PackageAdmin)this.injectedPackageAdmin.getValue();
            packageAdmin.resolveBundles(bundles);
        }
        final HashSet resolvedServices = new HashSet();
        for (Map.Entry entry : resolvableServices.entrySet()) {
            if (!((XBundle)entry.getValue()).isResolved()) continue;
            resolvedServices.add(entry.getKey());
        }
        final ServiceTarget serviceTarget = context.getChildTarget();
        ServiceTracker<XBundle> resolvedTracker = new ServiceTracker<XBundle>(){

            @Override
            protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                return resolvedServices.size() == trackedServices.size();
            }

            @Override
            protected void complete() {
                BootstrapBundlesResolve.this.installActivateService(serviceTarget, resolvedServices);
            }
        };
        for (ServiceName serviceName : resolvedServices) {
            XBundle bundle3 = (XBundle)resolvableServices.get(serviceName);
            serviceName = this.getBundleManager().getServiceName(bundle3, 4);
            ServiceController resolved = serviceRegistry.getRequiredService(serviceName);
            resolved.addListener((ServiceListener)resolvedTracker);
        }
        resolvedTracker.checkAndComplete();
    }

    private int getBeginningStartLevel() {
        String levelSpec = (String)this.getBundleManager().getProperty("org.osgi.framework.startlevel.beginning");
        if (levelSpec != null) {
            try {
                return Integer.parseInt(levelSpec);
            }
            catch (NumberFormatException nfe) {
                FrameworkLogger.LOGGER.errorInvalidBeginningStartLevel(levelSpec);
            }
        }
        return 1;
    }

    protected ServiceController<T> installActivateService(ServiceTarget serviceTarget, Set<ServiceName> resolvedServices) {
        return new BootstrapBundlesActivate(this.getServiceName().getParent(), resolvedServices).install(serviceTarget, this.getServiceListener());
    }
}

