/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;

public class BundleLock
extends ReentrantLock {
    public boolean tryLock(XBundle bundle2, LockMethod method) {
        try {
            FrameworkLogger.LOGGER.tracef("Aquire %s lock on: %s", (Object)method, bundle2);
            if (this.tryLock(30L, TimeUnit.SECONDS)) {
                return true;
            }
            FrameworkLogger.LOGGER.errorCannotAquireBundleLock(method.toString(), (Bundle)bundle2);
            return false;
        }
        catch (InterruptedException ex) {
            FrameworkLogger.LOGGER.debugf("Interupted while trying to aquire %s lock on: %s", (Object)method, bundle2);
            return false;
        }
    }

    public void unlock(XBundle bundle2, LockMethod method) {
        FrameworkLogger.LOGGER.tracef("Release %s lock on: %s", (Object)method, bundle2);
        this.unlock();
    }

    public static enum LockMethod {
        RESOLVE,
        START,
        STOP,
        UNINSTALL;

    }
}

