/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.internal.FrameworkLogger;

public class ServiceTracker<S>
extends AbstractServiceListener<S> {
    private final Set<ServiceName> addedNames = new HashSet<ServiceName>();
    private final Set<ServiceController<? extends S>> trackedControllers = new HashSet<ServiceController<? extends S>>();
    private final List<ServiceController<?>> started = new ArrayList();
    private final List<ServiceController<?>> failed = new ArrayList();
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final AtomicBoolean allComplete = new AtomicBoolean();
    private final boolean completeOnFirstFailure;

    public ServiceTracker() {
        this(true);
    }

    public ServiceTracker(boolean completeOnFail) {
        this.completeOnFirstFailure = completeOnFail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenerAdded(ServiceController<? extends S> controller) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            if (this.trackService(controller)) {
                FrameworkLogger.LOGGER.tracef("ServiceTracker controller added: %s", controller);
                this.addedNames.add(controller.getName());
                this.serviceListerAddedInternal(controller);
                ServiceController.State state = controller.getState();
                switch (state) {
                    case UP: {
                        this.started.add(controller);
                        this.serviceStarted(controller);
                        break;
                    }
                    case START_FAILED: {
                        this.failed.add(controller);
                        this.serviceStartFailed(controller);
                        break;
                    }
                    default: {
                        this.trackedControllers.add(controller);
                        break;
                    }
                }
            } else {
                controller.removeListener((ServiceListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(ServiceController<? extends S> controller, ServiceController.Transition transition) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            Service service = controller.getService();
            if (!this.allComplete.get()) {
                switch (transition) {
                    case STARTING_to_UP: {
                        if (service instanceof SynchronousListenerService) break;
                        FrameworkLogger.LOGGER.tracef("ServiceTracker transition to UP: " + controller.getName(), new Object[0]);
                        this.started.add(controller);
                        this.serviceStarted(controller);
                        this.serviceCompleteInternal(controller, false);
                        break;
                    }
                    case STARTING_to_START_FAILED: {
                        if (service instanceof SynchronousListenerService) break;
                        FrameworkLogger.LOGGER.tracef("ServiceTracker transition to START_FAILED: " + controller.getName(), new Object[0]);
                        this.failed.add(controller);
                        this.serviceStartFailed(controller);
                        this.serviceCompleteInternal(controller, true);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        this.serviceCompleteInternal(controller, false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousListenerServiceStarted(ServiceController<? extends S> controller) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            FrameworkLogger.LOGGER.tracef("Synchronous listener service started: " + controller.getName(), new Object[0]);
            this.started.add(controller);
            this.serviceStarted(controller);
            this.serviceCompleteInternal(controller, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousListenerServiceFailed(ServiceController<? extends S> controller, Throwable th) {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            FrameworkLogger.LOGGER.tracef("Synchronous listener service failed: " + controller.getName(), new Object[0]);
            this.failed.add(controller);
            this.serviceStartFailed(controller);
            this.serviceCompleteInternal(controller, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndComplete() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            if (this.trackedControllers.size() == 0 && this.allServicesAdded(Collections.unmodifiableSet(this.addedNames))) {
                this.completeInternal();
            }
        }
    }

    public boolean isComplete() {
        return this.allComplete.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceController<?>> getStartedServices() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            return Collections.unmodifiableList(this.started);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceController<?>> getFailedServices() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            return Collections.unmodifiableList(this.failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getFirstFailure() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            Throwable failure = null;
            for (ServiceController<?> controller : this.failed) {
                StartException startex = controller.getStartException();
                if (startex == null || startex.getCause() == null) continue;
                failure = startex.getCause();
                break;
            }
            return failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFailedServices() {
        Set<ServiceController<? extends S>> set = this.trackedControllers;
        synchronized (set) {
            return !this.failed.isEmpty();
        }
    }

    public boolean awaitCompletion() throws InterruptedException {
        this.completionLatch.await();
        return !this.hasFailedServices();
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.completionLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return !this.hasFailedServices();
    }

    protected boolean trackService(ServiceController<? extends S> controller) {
        return true;
    }

    protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
        return true;
    }

    protected void serviceListenerAdded(ServiceController<? extends S> controller) {
    }

    protected void serviceStarted(ServiceController<? extends S> controller) {
    }

    protected void serviceStartFailed(ServiceController<? extends S> controller) {
    }

    protected void complete() {
    }

    private void serviceListerAddedInternal(ServiceController<? extends S> controller) {
        this.serviceListenerAdded(controller);
        Service service = controller.getService();
        if (service instanceof SynchronousListenerService) {
            SynchronousListenerService sync = (SynchronousListenerService)service;
            sync.addListener(this);
        }
    }

    private void serviceListerRemoveInternal(ServiceController<? extends S> controller) {
        Service service = controller.getService();
        if (service instanceof SynchronousListenerService) {
            SynchronousListenerService sync = (SynchronousListenerService)service;
            sync.removeListener(this);
        }
    }

    private void serviceCompleteInternal(ServiceController<? extends S> controller, boolean failure) {
        this.trackedControllers.remove(controller);
        this.serviceListerRemoveInternal(controller);
        controller.removeListener((ServiceListener)this);
        if (failure && this.completeOnFirstFailure) {
            Iterator<ServiceController<S>> iterator = this.trackedControllers.iterator();
            while (iterator.hasNext()) {
                ServiceController<? extends S> aux = iterator.next();
                this.serviceListerRemoveInternal(aux);
                aux.removeListener((ServiceListener)this);
                iterator.remove();
            }
            this.completeInternal();
        } else {
            this.checkAndComplete();
        }
    }

    private void completeInternal() {
        if (this.allComplete.compareAndSet(false, true)) {
            FrameworkLogger.LOGGER.tracef("ServiceTracker complete: " + ((Object)((Object)this)).getClass().getName(), new Object[0]);
            this.completionLatch.countDown();
            this.complete();
        }
    }

    public static class SynchronousListenerServiceWrapper<T>
    implements SynchronousListenerService<T> {
        private final Set<ServiceTracker<T>> listeners = new HashSet<ServiceTracker<T>>();
        private final Service<T> delegate;

        public SynchronousListenerServiceWrapper(Service<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized void addListener(ServiceTracker<T> listener) {
            this.listeners.add(listener);
        }

        @Override
        public synchronized void removeListener(ServiceTracker<T> listener) {
            this.listeners.remove(listener);
        }

        public void start(StartContext context) throws StartException {
            try {
                this.delegate.start(context);
                this.startCompleted(context);
            }
            catch (StartException ex) {
                this.startFailed(context, ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.startFailed(context, ex);
                throw ex;
            }
        }

        public void stop(StopContext context) {
            this.delegate.stop(context);
        }

        @Override
        public void startCompleted(StartContext context) {
            for (ServiceTracker<T> listener : new ArrayList<ServiceTracker<T>>(this.listeners)) {
                listener.synchronousListenerServiceStarted(context.getController());
            }
        }

        @Override
        public void startFailed(StartContext context, Throwable th) {
            for (ServiceTracker<T> listener : new ArrayList<ServiceTracker<T>>(this.listeners)) {
                listener.synchronousListenerServiceFailed(context.getController(), th);
            }
        }

        public T getValue() throws IllegalStateException, IllegalArgumentException {
            return (T)this.delegate.getValue();
        }
    }

    public static interface SynchronousListenerService<T>
    extends Service<T> {
        public void addListener(ServiceTracker<T> var1);

        public void removeListener(ServiceTracker<T> var1);

        public void startCompleted(StartContext var1);

        public void startFailed(StartContext var1, Throwable var2);
    }
}

