/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.naming;

import java.util.List;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.InitialContextFactoryBuilder;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.osgi.AbstractSubsystemExtension;
import org.jboss.as.osgi.naming.BundleContextBindingProcessor;
import org.jboss.as.osgi.naming.BundleContextBindingService;
import org.jboss.as.osgi.naming.JNDIServiceListener;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;

public class NamingExtension
extends AbstractSubsystemExtension {
    private final InjectedValue<NamingStore> injectedNamingStore = new InjectedValue();
    private JNDIServiceListener jndiServiceListener;

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(BundleContextBindingService.addService(serviceTarget));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("osgi", Phase.DEPENDENCIES, 6400, (DeploymentUnitProcessor)new BundleContextBindingProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void configureServiceDependencies(ServiceName serviceName, ServiceBuilder<?> builder) {
        if (serviceName.equals(IntegrationServices.SYSTEM_SERVICES_PLUGIN)) {
            builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, NamingService.SERVICE_NAME, NamingStore.class, this.injectedNamingStore);
        }
    }

    public void startSystemServices(StartContext startContext, BundleContext systemContext) {
        NamingStore namingStore = (NamingStore)this.injectedNamingStore.getOptionalValue();
        if (namingStore != null) {
            String[] classes = new String[]{javax.naming.spi.InitialContextFactoryBuilder.class.getName(), InitialContextFactoryBuilder.class.getName()};
            systemContext.registerService(classes, (Object)new InitialContextFactoryBuilder(), null);
            this.jndiServiceListener = new JNDIServiceListener(systemContext);
            try {
                String filter = "(objectClass=" + ObjectFactory.class.getName() + ")";
                systemContext.addServiceListener((ServiceListener)this.jndiServiceListener, filter);
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
        }
    }

    public void stopSystemServices(StopContext stopContext, BundleContext systemContext) {
        if (this.jndiServiceListener != null) {
            systemContext.removeServiceListener((ServiceListener)this.jndiServiceListener);
        }
    }
}

