/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.dynamicresource.descriptionproviders.StatisticsDescriptionProvider;
import org.jboss.as.connector.dynamicresource.operations.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;

public class DataSourceStatisticsListener
extends AbstractServiceListener<Object> {
    private static final PathElement JDBC_STATISTICS = PathElement.pathElement((String)"statistics", (String)"jdbc");
    private static final PathElement POOL_STATISTICS = PathElement.pathElement((String)"statistics", (String)"pool");
    private final ManagementResourceRegistration registration;
    private final Resource resource;
    private final String dsName;

    public DataSourceStatisticsListener(ManagementResourceRegistration registration, Resource resource, String dsName) {
        this.registration = registration;
        this.resource = resource;
        this.dsName = dsName;
    }

    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_UP: {
                ManagementResourceRegistration subRegistration;
                CommonDeployment deploymentMD = ((AbstractDataSourceService)controller.getService()).getDeploymentMD();
                StatisticsPlugin jdbcStats = deploymentMD.getDataSources()[0].getStatistics();
                PoolStatistics poolStats = deploymentMD.getDataSources()[0].getPool().getStatistics();
                int jdbcStatsSize = jdbcStats.getNames().size();
                int poolStatsSize = poolStats.getNames().size();
                if (jdbcStatsSize <= 0 && poolStatsSize <= 0) break;
                ManagementResourceRegistration managementResourceRegistration = subRegistration = this.registration.isAllowsOverride() ? this.registration.registerOverrideModel(this.dsName, DataSourcesSubsystemProviders.OVERRIDE_DS_DESC) : this.registration;
                if (jdbcStatsSize > 0) {
                    ManagementResourceRegistration jdbcRegistration = subRegistration.registerSubModel(JDBC_STATISTICS, (DescriptionProvider)new StatisticsDescriptionProvider(DataSourcesSubsystemProviders.RESOURCE_NAME, "statistics", jdbcStats));
                    jdbcRegistration.setRuntimeOnly(true);
                    jdbcRegistration.registerOperationHandler("clear-statistics", (OperationStepHandler)new ClearStatisticsHandler(jdbcStats), DataSourcesSubsystemProviders.CLEAR_STATISTICS_DESC, false);
                    for (String statName : jdbcStats.getNames()) {
                        jdbcRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler(jdbcStats));
                    }
                    this.resource.registerChild(JDBC_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(JDBC_STATISTICS));
                }
                if (poolStatsSize <= 0) break;
                ManagementResourceRegistration poolRegistration = subRegistration.registerSubModel(POOL_STATISTICS, (DescriptionProvider)new StatisticsDescriptionProvider(DataSourcesSubsystemProviders.RESOURCE_NAME, "statistics", new StatisticsPlugin[]{poolStats}));
                poolRegistration.setRuntimeOnly(true);
                poolRegistration.registerOperationHandler("clear-statistics", (OperationStepHandler)new ClearStatisticsHandler(new StatisticsPlugin[]{poolStats}), DataSourcesSubsystemProviders.CLEAR_STATISTICS_DESC, false);
                for (String statName : poolStats.getNames()) {
                    poolRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler((StatisticsPlugin)poolStats));
                }
                this.resource.registerChild(POOL_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(JDBC_STATISTICS));
                break;
            }
            case UP_to_STOP_REQUESTED: {
                ManagementResourceRegistration subRegistration = this.registration.getOverrideModel(this.dsName);
                if (subRegistration != null) {
                    subRegistration.unregisterSubModel(JDBC_STATISTICS);
                    subRegistration.unregisterSubModel(POOL_STATISTICS);
                    this.registration.unregisterOverrideModel(this.dsName);
                }
                if (this.resource.hasChild(JDBC_STATISTICS)) {
                    this.resource.removeChild(JDBC_STATISTICS);
                }
                if (!this.resource.hasChild(POOL_STATISTICS)) break;
                this.resource.removeChild(POOL_STATISTICS);
                break;
            }
        }
    }
}

