/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.common.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyAdd;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyRemove;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.DisableRequiredWriteAttributeHandler;
import org.jboss.as.connector.subsystems.datasources.DsParser;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.GetInstalledDriverOperationHandler;
import org.jboss.as.connector.subsystems.datasources.InstalledDriversListOperationHandler;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverAdd;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverRemove;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.connector.subsystems.datasources.XMLDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XMLXaDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertyAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertyRemove;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceRemove;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.v11.DataSource;
import org.jboss.jca.common.api.metadata.ds.v11.XaDataSource;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "datasources";
    private static final String RESOURCE_NAME = DataSourcesExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final EnumSet<OperationEntry.Flag> RUNTIME_ONLY_FLAG = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private static final int MANAGEMENT_API_MICRO_VERSION = 1;

    public void initialize(ExtensionContext context) {
        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Initializing Datasources Extension", new Object[0]);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1, 1);
        registration.registerXMLElementWriter((XMLElementWriter)DataSourceSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(DataSourcesSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)DataSourcesSubsystemAdd.INSTANCE, DataSourcesSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, DataSourcesSubsystemProviders.SUBSYSTEM_REMOVE_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)DataSourcesSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)DataSourcesSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerReadOnlyAttribute("installed-drivers", null, AttributeAccess.Storage.CONFIGURATION);
        if (registerRuntimeOnly) {
            subsystem.registerOperationHandler("installed-drivers-list", (OperationStepHandler)InstalledDriversListOperationHandler.INSTANCE, DataSourcesSubsystemProviders.INSTALLED_DRIVERS_LIST_DESC, RUNTIME_ONLY_FLAG);
            subsystem.registerOperationHandler("get-installed-driver", (OperationStepHandler)GetInstalledDriverOperationHandler.INSTANCE, DataSourcesSubsystemProviders.GET_INSTALLED_DRIVER_DESC, RUNTIME_ONLY_FLAG);
        }
        ManagementResourceRegistration jdbcDrivers = subsystem.registerSubModel(PathElement.pathElement((String)"jdbc-driver"), DataSourcesSubsystemProviders.JDBC_DRIVER_DESC);
        jdbcDrivers.registerOperationHandler("add", (OperationStepHandler)JdbcDriverAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerOperationHandler("remove", (OperationStepHandler)JdbcDriverRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.DRIVER_MAJOR_VERSION, null);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.DRIVER_MINOR_VERSION, null);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.DRIVER_DATASOURCE_CLASS_NAME, null);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.XADATASOURCECLASS, null);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.DRIVER_CLASS_NAME, null);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.DRIVER_NAME, null);
        jdbcDrivers.registerReadOnlyAttribute((AttributeDefinition)Constants.DRIVER_MODULE_NAME, null);
        jdbcDrivers.registerReadOnlyAttribute("deployment-name", null, AttributeAccess.Storage.CONFIGURATION);
        jdbcDrivers.registerReadOnlyAttribute("jdbc-compliant", null, AttributeAccess.Storage.CONFIGURATION);
        jdbcDrivers.registerReadOnlyAttribute("module-slot", null, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration dataSources = subsystem.registerSubModel(PathElement.pathElement((String)"data-source"), DataSourcesSubsystemProviders.DATA_SOURCE_DESC);
        dataSources.registerOperationHandler("add", (OperationStepHandler)DataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("remove", (OperationStepHandler)DataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("enable", (OperationStepHandler)DataSourceEnable.LOCAL_INSTANCE, DataSourcesSubsystemProviders.ENABLE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("disable", (OperationStepHandler)DataSourceDisable.LOCAL_INSTANCE, DataSourcesSubsystemProviders.DISABLE_DATA_SOURCE_DESC, false);
        if (registerRuntimeOnly) {
            dataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
            dataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
            dataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        }
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE) {
            if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                dataSources.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                continue;
            }
            dataSources.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)new DisableRequiredWriteAttributeHandler((AttributeDefinition[])DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE));
        }
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.READONLY_DATASOURCE_ATTRIBUTE) {
            dataSources.registerReadOnlyAttribute((AttributeDefinition)attribute, null);
        }
        ManagementResourceRegistration configAdapter = dataSources.registerSubModel(PathElement.pathElement((String)Constants.CONNECTION_PROPERTIES.getName()), DataSourcesSubsystemProviders.CONNECTION_PROPERTIES_DESC);
        configAdapter.registerOperationHandler("add", (OperationStepHandler)ConnectionPropertyAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_CONNECTION_PROPERTIES_DESC, false);
        configAdapter.registerOperationHandler("remove", (OperationStepHandler)ConnectionPropertyRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_CONNECTION_PROPERTIES_DESC, false);
        configAdapter.registerReadOnlyAttribute((AttributeDefinition)Constants.CONNECTION_PROPERTY_VALUE, null);
        ManagementResourceRegistration xaDataSources = subsystem.registerSubModel(PathElement.pathElement((String)"xa-data-source"), DataSourcesSubsystemProviders.XA_DATA_SOURCE_DESC);
        xaDataSources.registerOperationHandler("add", (OperationStepHandler)XaDataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("remove", (OperationStepHandler)XaDataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("enable", (OperationStepHandler)DataSourceEnable.XA_INSTANCE, DataSourcesSubsystemProviders.ENABLE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("disable", (OperationStepHandler)DataSourceDisable.XA_INSTANCE, DataSourcesSubsystemProviders.DISABLE_XA_DATA_SOURCE_DESC, false);
        if (registerRuntimeOnly) {
            xaDataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
            xaDataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
            xaDataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        }
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE) {
            if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                xaDataSources.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                continue;
            }
            xaDataSources.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)new DisableRequiredWriteAttributeHandler((AttributeDefinition[])DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE));
        }
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.READONLY_XA_DATASOURCE_ATTRIBUTE) {
            xaDataSources.registerReadOnlyAttribute((AttributeDefinition)attribute, null);
        }
        ManagementResourceRegistration xadatasourcePropertyAdapter = xaDataSources.registerSubModel(PathElement.pathElement((String)Constants.XADATASOURCE_PROPERTIES.getName()), DataSourcesSubsystemProviders.XADATASOURCE_PROPERTIES_DESC);
        xadatasourcePropertyAdapter.registerOperationHandler("add", (OperationStepHandler)XaDataSourcePropertyAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_XADATASOURCE_PROPERTIES_DESC, false);
        xadatasourcePropertyAdapter.registerOperationHandler("remove", (OperationStepHandler)XaDataSourcePropertyRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_XADATASOURCE_PROPERTIES_DESC, false);
        xadatasourcePropertyAdapter.registerReadOnlyAttribute((AttributeDefinition)Constants.XADATASOURCE_PROPERTY_VALUE, null);
        if (registerRuntimeOnly) {
            this.registerDeploymentsModel(registration);
        }
    }

    private void registerDeploymentsModel(SubsystemRegistration registration) {
        SimpleResourceDefinition deploymentsDef = new SimpleResourceDefinition(PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), DataSourcesExtension.getResourceDescriptionResolver("deployed"));
        ManagementResourceRegistration deploymentsRegistration = registration.registerDeploymentModel((ResourceDefinition)deploymentsDef);
        ManagementResourceRegistration dataSources = deploymentsRegistration.registerSubModel(PathElement.pathElement((String)"data-source"), DataSourcesSubsystemProviders.DATA_SOURCE_DESC);
        dataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        dataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        dataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        ManagementResourceRegistration configAdapter = dataSources.registerSubModel(PathElement.pathElement((String)Constants.CONNECTION_PROPERTIES.getName()), DataSourcesSubsystemProviders.CONNECTION_PROPERTIES_DESC);
        configAdapter.registerReadOnlyAttribute(Constants.CONNECTION_PROPERTY_VALUE.getName(), (OperationStepHandler)XMLDataSourceRuntimeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE) {
            dataSources.registerReadOnlyAttribute(attribute.getName(), (OperationStepHandler)XMLDataSourceRuntimeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        }
        ManagementResourceRegistration xaDataSources = deploymentsRegistration.registerSubModel(PathElement.pathElement((String)"xa-data-source"), DataSourcesSubsystemProviders.XA_DATA_SOURCE_DESC);
        xaDataSources.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        xaDataSources.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        xaDataSources.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE, DataSourcesSubsystemProviders.TEST_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        ManagementResourceRegistration xadatasourcePropertyAdapter = xaDataSources.registerSubModel(PathElement.pathElement((String)Constants.XADATASOURCE_PROPERTIES.getName()), DataSourcesSubsystemProviders.XADATASOURCE_PROPERTIES_DESC);
        xadatasourcePropertyAdapter.registerReadOnlyAttribute(Constants.CONNECTION_PROPERTY_VALUE.getName(), (OperationStepHandler)XMLXaDataSourceRuntimeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        for (SimpleAttributeDefinition attribute : DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE) {
            xaDataSources.registerReadOnlyAttribute(attribute.getName(), (OperationStepHandler)XMLXaDataSourceRuntimeHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_1_0.getUriString(), (XMLElementReader)DataSourceSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_1_1.getUriString(), (XMLElementReader)DataSourceSubsystemParser.INSTANCE);
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, DataSourcesExtension.class.getClassLoader(), true, true);
    }

    private static class DataSourcesSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final DataSourcesSubsystemDescribeHandler INSTANCE = new DataSourcesSubsystemDescribeHandler();

        private DataSourcesSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode enableOperation;
            ModelNode addPropOperation;
            ModelNode propAddress;
            ModelNode dataSource;
            ModelNode addOperation;
            ModelNode address;
            ModelNode result = context.getResult();
            PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
            ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode subsystemAdd = new ModelNode();
            subsystemAdd.get("operation").set("add");
            subsystemAdd.get("address").set(rootAddress.toModelNode());
            result.add(subsystemAdd);
            if (subModel.hasDefined("jdbc-driver")) {
                for (Property jdbcDriver : subModel.get("jdbc-driver").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("jdbc-driver", jdbcDriver.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    addOperation.get(Constants.DRIVER_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_NAME.getName()));
                    addOperation.get(Constants.DRIVER_MODULE_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_MODULE_NAME.getName()));
                    addOperation.get(Constants.DRIVER_MAJOR_VERSION.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_MAJOR_VERSION.getName()));
                    addOperation.get(Constants.DRIVER_MINOR_VERSION.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_MINOR_VERSION.getName()));
                    addOperation.get(Constants.DRIVER_CLASS_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_CLASS_NAME.getName()));
                    addOperation.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()));
                    addOperation.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).set(jdbcDriver.getValue().get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()));
                    result.add(addOperation);
                }
            }
            if (subModel.hasDefined("data-source")) {
                for (Property dataSourceProp : subModel.get("data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, Constants.CONNECTION_PROPERTIES.getName(), DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE);
                    addOperation.get(Constants.DATASOURCE_DRIVER.getName()).set(dataSourceProp.getValue().get(Constants.DATASOURCE_DRIVER.getName()));
                    result.add(addOperation);
                    if (dataSource.hasDefined(Constants.CONNECTION_PROPERTIES.getName())) {
                        for (Property prop : dataSource.get(Constants.CONNECTION_PROPERTIES.getName()).asPropertyList()) {
                            propAddress = address.clone();
                            propAddress.add(Constants.CONNECTION_PROPERTIES.getName(), prop.getName());
                            addPropOperation = Util.getEmptyOperation((String)"add", (ModelNode)propAddress);
                            addPropOperation.get("value").set(prop.getValue().get("value").asString());
                            result.add(addPropOperation);
                        }
                    }
                    if (dataSource.hasDefined(Constants.ENABLED.getName()) && !dataSource.get(Constants.ENABLED.getName()).asBoolean()) continue;
                    enableOperation = new ModelNode();
                    enableOperation.get("operation").set("enable");
                    enableOperation.get("address").set(address);
                    enableOperation.get("persistent").set(dataSource.hasDefined(Constants.ENABLED.getName()));
                    result.add(enableOperation);
                }
            }
            if (subModel.hasDefined("xa-data-source")) {
                for (Property dataSourceProp : subModel.get("xa-data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("xa-data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, Constants.XADATASOURCE_PROPERTIES.getName(), DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE);
                    addOperation.get(Constants.DATASOURCE_DRIVER.getName()).set(dataSourceProp.getValue().get(Constants.DATASOURCE_DRIVER.getName()));
                    result.add(addOperation);
                    if (dataSource.hasDefined(Constants.XADATASOURCE_PROPERTIES.getName())) {
                        for (Property prop : dataSource.get(Constants.XADATASOURCE_PROPERTIES.getName()).asPropertyList()) {
                            propAddress = address.clone();
                            propAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), prop.getName());
                            addPropOperation = Util.getEmptyOperation((String)"add", (ModelNode)propAddress);
                            addPropOperation.get("value").set(prop.getValue().get("value").asString());
                            result.add(addPropOperation);
                        }
                    }
                    if (dataSource.hasDefined(Constants.ENABLED.getName()) && !dataSource.get(Constants.ENABLED.getName()).asBoolean()) continue;
                    enableOperation = new ModelNode();
                    enableOperation.get("operation").set("enable");
                    enableOperation.get("address").set(address);
                    enableOperation.get("persistent").set(dataSource.hasDefined(Constants.ENABLED.getName()));
                    result.add(enableOperation);
                }
            }
            context.stepCompleted();
        }

        public ModelNode getModelDescription(Locale locale) {
            return GenericSubsystemDescribeHandler.DEFINITION.getDescriptionProvider().getModelDescription(locale);
        }
    }

    public static final class DataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final DataSourceSubsystemParser INSTANCE = new DataSourceSubsystemParser();

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement(DataSourcesExtension.SUBSYSTEM_NAME);
            if (node.hasDefined("data-source") || node.hasDefined("xa-data-source")) {
                boolean isXADataSource = false;
                if (node.hasDefined("data-source")) {
                    this.writeDS(writer, false, node.get("data-source").asPropertyList());
                }
                if (node.hasDefined("xa-data-source")) {
                    this.writeDS(writer, true, node.get("xa-data-source").asPropertyList());
                }
            }
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(DataSources.Tag.DRIVERS.getLocalName());
                for (Property driverProperty : node.get("jdbc-driver").asPropertyList()) {
                    writer.writeStartElement(DataSources.Tag.DRIVER.getLocalName());
                    writer.writeAttribute(Driver.Attribute.NAME.getLocalName(), driverProperty.getValue().require(Constants.DRIVER_NAME.getName()).asString());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MODULE, Constants.DRIVER_MODULE_NAME.getName());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MAJOR_VERSION, Constants.DRIVER_MAJOR_VERSION.getName());
                    this.writeAttributeIfHas(writer, driverProperty.getValue(), Driver.Attribute.MINOR_VERSION, Constants.DRIVER_MINOR_VERSION.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.DRIVER_CLASS.getLocalName(), Constants.DRIVER_CLASS_NAME.getName());
                    this.writeElementIfHas(writer, driverProperty.getValue(), Driver.Tag.XA_DATASOURCE_CLASS.getLocalName(), Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeDS(XMLExtendedStreamWriter writer, boolean isXADataSource, List<Property> propertyList) throws XMLStreamException {
            for (Property property : propertyList) {
                boolean statementRequired;
                boolean timeoutRequired;
                boolean validationRequired;
                boolean recoveryRequired;
                boolean securityRequired;
                boolean poolRequired;
                ModelNode dataSourceNode = property.getValue();
                writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                Constants.JTA.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.JNDINAME.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                writer.writeAttribute("pool-name", property.getName());
                Constants.ENABLED.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.USE_JAVA_CONTEXT.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.SPY.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.USE_CCM.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                if (!isXADataSource) {
                    Constants.CONNECTION_URL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.DRIVER_CLASS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.DATASOURCE_CLASS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.CONNECTION_PROPERTIES.getName())) {
                        for (Property connectionProperty : dataSourceNode.get(Constants.CONNECTION_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().get("value").asString(), DataSource.Tag.CONNECTION_PROPERTY.getLocalName());
                        }
                    }
                }
                if (isXADataSource) {
                    if (dataSourceNode.hasDefined(Constants.XADATASOURCE_PROPERTIES.getName())) {
                        for (Property prop : dataSourceNode.get(Constants.XADATASOURCE_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(writer, dataSourceNode, prop.getName(), prop.getValue().get("value").asString(), XaDataSource.Tag.XA_DATASOURCE_PROPERTY.getLocalName());
                        }
                    }
                    Constants.XADATASOURCECLASS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                }
                Constants.DATASOURCE_DRIVER.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                if (isXADataSource) {
                    Constants.URL_DELIMITER.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                }
                Constants.NEW_CONNECTION_SQL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                Constants.TRANSACTION_ISOLATION.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                if (!isXADataSource) {
                    Constants.URL_DELIMITER.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                }
                boolean bl = poolRequired = org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.isMarshallable(dataSourceNode);
                if (isXADataSource) {
                    boolean bl2 = poolRequired = poolRequired || Constants.SAME_RM_OVERRIDE.isMarshallable(dataSourceNode) || Constants.INTERLEAVING.isMarshallable(dataSourceNode) || Constants.NOTXSEPARATEPOOL.isMarshallable(dataSourceNode) || Constants.PAD_XID.isMarshallable(dataSourceNode) || Constants.WRAP_XA_RESOURCE.isMarshallable(dataSourceNode);
                }
                if (poolRequired) {
                    writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                    org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.get(Constants.ALLOW_MULTIPLE_USERS.getName()).asBoolean(false)) {
                        writer.writeEmptyElement(Constants.ALLOW_MULTIPLE_USERS.getXmlName());
                    }
                    if (isXADataSource) {
                        Constants.SAME_RM_OVERRIDE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.INTERLEAVING.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.NOTXSEPARATEPOOL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.PAD_XID.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.WRAP_XA_RESOURCE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    }
                    writer.writeEndElement();
                }
                boolean bl3 = securityRequired = Constants.USERNAME.isMarshallable(dataSourceNode) || Constants.PASSWORD.isMarshallable(dataSourceNode) || Constants.SECURITY_DOMAIN.isMarshallable(dataSourceNode) || Constants.REAUTHPLUGIN_CLASSNAME.isMarshallable(dataSourceNode) || Constants.REAUTHPLUGIN_PROPERTIES.isMarshallable(dataSourceNode);
                if (securityRequired) {
                    writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                    Constants.USERNAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.PASSWORD.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.SECURITY_DOMAIN.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.REAUTHPLUGIN_CLASSNAME.getName())) {
                        writer.writeStartElement(DsSecurity.Tag.REAUTH_PLUGIN.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.REAUTHPLUGIN_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.REAUTHPLUGIN_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.REAUTHPLUGIN_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                boolean bl4 = recoveryRequired = Constants.RECOVERY_USERNAME.isMarshallable(dataSourceNode) || Constants.RECOVERY_PASSWORD.isMarshallable(dataSourceNode) || Constants.RECOVERY_SECURITY_DOMAIN.isMarshallable(dataSourceNode) || Constants.RECOVERLUGIN_CLASSNAME.isMarshallable(dataSourceNode) || Constants.NO_RECOVERY.isMarshallable(dataSourceNode) || Constants.RECOVERLUGIN_PROPERTIES.isMarshallable(dataSourceNode);
                if (recoveryRequired && isXADataSource) {
                    writer.writeStartElement(XaDataSource.Tag.RECOVERY.getLocalName());
                    Constants.NO_RECOVERY.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                    if (this.hasAnyOf(dataSourceNode, Constants.RECOVERY_USERNAME, Constants.RECOVERY_PASSWORD, Constants.RECOVERY_SECURITY_DOMAIN)) {
                        writer.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                        Constants.RECOVERY_USERNAME.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.RECOVERY_PASSWORD.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.RECOVERY_SECURITY_DOMAIN.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    if (this.hasAnyOf(dataSourceNode, Constants.RECOVERLUGIN_CLASSNAME)) {
                        writer.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.RECOVERLUGIN_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.RECOVERLUGIN_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                boolean bl5 = validationRequired = Constants.VALIDCONNECTIONCHECKERCLASSNAME.isMarshallable(dataSourceNode) || Constants.VALIDCONNECTIONCHECKER_PROPERTIES.isMarshallable(dataSourceNode) || Constants.CHECKVALIDCONNECTIONSQL.isMarshallable(dataSourceNode) || Constants.VALIDATEONMATCH.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.isMarshallable(dataSourceNode) || Constants.STALECONNECTIONCHECKERCLASSNAME.isMarshallable(dataSourceNode) || Constants.STALECONNECTIONCHECKER_PROPERTIES.isMarshallable(dataSourceNode) || Constants.EXCEPTIONSORTERCLASSNAME.isMarshallable(dataSourceNode) || Constants.EXCEPTIONSORTER_PROPERTIES.isMarshallable(dataSourceNode);
                if (validationRequired) {
                    writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                    if (dataSourceNode.hasDefined(Constants.VALIDCONNECTIONCHECKERCLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.VALID_CONNECTION_CHECKER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.VALIDCONNECTIONCHECKERCLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.VALIDCONNECTIONCHECKER_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.VALIDCONNECTIONCHECKER_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    Constants.CHECKVALIDCONNECTIONSQL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.VALIDATEONMATCH.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    if (dataSourceNode.hasDefined(Constants.STALECONNECTIONCHECKERCLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.STALE_CONNECTION_CHECKER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.STALECONNECTIONCHECKERCLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.STALECONNECTIONCHECKER_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.STALECONNECTIONCHECKER_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (dataSourceNode.hasDefined(Constants.EXCEPTIONSORTERCLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.EXCEPTION_SORTER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.EXCEPTIONSORTERCLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.EXCEPTIONSORTER_PROPERTIES.getName())) {
                            for (Property connectionProperty : dataSourceNode.get(Constants.EXCEPTIONSORTER_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                boolean bl6 = timeoutRequired = org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.isMarshallable(dataSourceNode) || org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.isMarshallable(dataSourceNode) || Constants.SETTXQUERYTIMEOUT.isMarshallable(dataSourceNode) || Constants.QUERYTIMEOUT.isMarshallable(dataSourceNode) || Constants.USETRYLOCK.isMarshallable(dataSourceNode) || Constants.ALLOCATION_RETRY.isMarshallable(dataSourceNode) || Constants.ALLOCATION_RETRY_WAIT_MILLIS.isMarshallable(dataSourceNode) || Constants.XA_RESOURCE_TIMEOUT.isMarshallable(dataSourceNode);
                if (timeoutRequired) {
                    writer.writeStartElement(DataSource.Tag.TIMEOUT.getLocalName());
                    Constants.SETTXQUERYTIMEOUT.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.QUERYTIMEOUT.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.USETRYLOCK.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.ALLOCATION_RETRY.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.ALLOCATION_RETRY_WAIT_MILLIS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.XA_RESOURCE_TIMEOUT.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (statementRequired = this.hasAnyOf(dataSourceNode, Constants.TRACKSTATEMENTS, Constants.PREPAREDSTATEMENTSCACHESIZE, Constants.SHAREPREPAREDSTATEMENTS)) {
                    writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                    Constants.TRACKSTATEMENTS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.PREPAREDSTATEMENTSCACHESIZE.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.SHAREPREPAREDSTATEMENTS.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Recovery.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Driver.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                String content = node.get(identifier).asString();
                if (content.indexOf(10) > -1) {
                    writer.writeCharacters(content);
                } else {
                    char[] chars = content.toCharArray();
                    writer.writeCharacters(chars, 0, chars.length);
                }
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, XaDataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DsSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Validation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (node.has(identifier) && node.get(identifier).asBoolean()) {
                writer.writeEmptyElement(localName);
            }
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private boolean hasAnyOf(ModelNode node, SimpleAttributeDefinition ... names) {
            for (SimpleAttributeDefinition current : names) {
                if (!this.has(node, current.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", DataSourcesExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.tracef("%s -> %s", localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                DsParser parser = new DsParser();
                                parser.parse(reader, list, address);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block1;
                            }
                        }
                        break;
                    }
                    case DATASOURCES_1_1: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.tracef("%s -> %s", localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                DsParser parser = new DsParser();
                                parser.parse(reader, list, address);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block1;
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

