/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class RaActivate
implements OperationStepHandler {
    static final RaActivate INSTANCE = new RaActivate();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode address = operation.require("address");
        final String raName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    RaOperationUtil.deactivateIfActive(context, raName);
                    String archiveName = model.get(Constants.ARCHIVE.getName()).asString();
                    RaOperationUtil.activate(context, raName, archiveName);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            try {
                                RaOperationUtil.deactivateIfActive(context, raName);
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

