/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.InactiveResourceAdapterDeploymentService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.RaServicesFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class RaOperationUtil {
    public static ModifiableResourceAdapter buildResourceAdaptersObject(OperationContext context, ModelNode operation) throws OperationFailedException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        ArrayList<CommonConnDef> connectionDefinitions = new ArrayList<CommonConnDef>(0);
        ArrayList<CommonAdminObject> adminObjects = new ArrayList<CommonAdminObject>(0);
        String archive = Constants.ARCHIVE.resolveModelAttribute(context, operation).asString();
        TransactionSupportEnum transactionSupport = operation.hasDefined(Constants.TRANSACTION_SUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)operation.get(Constants.TRANSACTION_SUPPORT.getName()).asString()) : null;
        String bootstrapContext = Constants.BOOTSTRAP_CONTEXT.resolveModelAttribute(context, operation).asString();
        ArrayList<String> beanValidationGroups = null;
        if (operation.hasDefined(Constants.BEANVALIDATION_GROUPS.getName())) {
            beanValidationGroups = new ArrayList<String>(operation.get(Constants.BEANVALIDATION_GROUPS.getName()).asList().size());
            for (ModelNode beanValidation : operation.get(Constants.BEANVALIDATION_GROUPS.getName()).asList()) {
                beanValidationGroups.add(beanValidation.asString());
            }
        }
        ModifiableResourceAdapter ra = new ModifiableResourceAdapter(archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext);
        return ra;
    }

    public static ModifiableConnDef buildConnectionDefinitionObject(OperationContext context, ModelNode operation, String poolName, boolean isXa) throws OperationFailedException, ValidateException {
        ModelNode backgroundValidationMillisModel;
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = Constants.CLASS_NAME.resolveModelAttribute(context, operation).asString();
        String jndiName = Constants.JNDINAME.resolveModelAttribute(context, operation).asString();
        boolean enabled = Constants.ENABLED.resolveModelAttribute(context, operation).asBoolean();
        boolean useJavaContext = Constants.USE_JAVA_CONTEXT.resolveModelAttribute(context, operation).asBoolean();
        boolean useCcm = Constants.USE_CCM.resolveModelAttribute(context, operation).asBoolean();
        int maxPoolSize = org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.resolveModelAttribute(context, operation).asInt();
        int minPoolSize = org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.resolveModelAttribute(context, operation).asInt();
        boolean prefill = org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.resolveModelAttribute(context, operation).asBoolean();
        boolean useStrictMin = org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.resolveModelAttribute(context, operation).asBoolean();
        String flushStrategyString = org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.resolveModelAttribute(context, operation).asString();
        FlushStrategy flushStrategy = FlushStrategy.forName((String)flushStrategyString);
        boolean isSameRM = Constants.SAME_RM_OVERRIDE.resolveModelAttribute(context, operation).asBoolean();
        boolean interlivng = Constants.INTERLEAVING.resolveModelAttribute(context, operation).asBoolean();
        boolean padXid = Constants.PAD_XID.resolveModelAttribute(context, operation).asBoolean();
        boolean wrapXaResource = Constants.WRAP_XA_RESOURCE.resolveModelAttribute(context, operation).asBoolean();
        boolean noTxSeparatePool = Constants.NOTXSEPARATEPOOL.resolveModelAttribute(context, operation).asBoolean();
        ModelNode allocationRetryModel = Constants.ALLOCATION_RETRY.resolveModelAttribute(context, operation);
        ModelNode allocationRetryWaitMillisModel = Constants.ALLOCATION_RETRY_WAIT_MILLIS.resolveModelAttribute(context, operation);
        ModelNode blockingTimeoutMillisModel = org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.resolveModelAttribute(context, operation);
        ModelNode idleTimeoutMinutesModel = org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.resolveModelAttribute(context, operation);
        ModelNode xaResourceTimeoutModel = Constants.XA_RESOURCE_TIMEOUT.resolveModelAttribute(context, operation);
        Integer allocationRetry = allocationRetryModel.isDefined() ? Integer.valueOf(allocationRetryModel.asInt()) : null;
        Long allocationRetryWaitMillis = allocationRetryWaitMillisModel.isDefined() ? Long.valueOf(allocationRetryWaitMillisModel.asLong()) : null;
        Long blockingTimeoutMillis = blockingTimeoutMillisModel.isDefined() ? Long.valueOf(blockingTimeoutMillisModel.asLong()) : null;
        Long idleTimeoutMinutes = idleTimeoutMinutesModel.isDefined() ? Long.valueOf(idleTimeoutMinutesModel.asLong()) : null;
        Integer xaResourceTimeout = xaResourceTimeoutModel.isDefined() ? Integer.valueOf(xaResourceTimeoutModel.asInt()) : null;
        CommonTimeOutImpl timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        Object pool = isXa ? new CommonXaPoolImpl(Integer.valueOf(minPoolSize), Integer.valueOf(maxPoolSize), Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, Boolean.valueOf(isSameRM), Boolean.valueOf(interlivng), Boolean.valueOf(padXid), Boolean.valueOf(wrapXaResource), Boolean.valueOf(noTxSeparatePool)) : new CommonPoolImpl(Integer.valueOf(minPoolSize), Integer.valueOf(maxPoolSize), Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        ModelNode securityDomainModel = Constants.SECURITY_DOMAIN.resolveModelAttribute(context, operation);
        String securityDomain = securityDomainModel.isDefined() ? securityDomainModel.asString() : null;
        ModelNode securityDomainAndApplicationModel = Constants.SECURITY_DOMAIN_AND_APPLICATION.resolveModelAttribute(context, operation);
        String securityDomainAndApplication = securityDomainAndApplicationModel.isDefined() ? securityDomainAndApplicationModel.asString() : null;
        boolean application = Constants.APPLICATION.resolveModelAttribute(context, operation).asBoolean();
        CommonSecurityImpl security = null;
        if (securityDomain != null || securityDomainAndApplication != null) {
            security = new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application);
        }
        Long backgroundValidationMillis = (backgroundValidationMillisModel = org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.resolveModelAttribute(context, operation)).isDefined() ? Long.valueOf(backgroundValidationMillisModel.asLong()) : null;
        boolean backgroundValidation = org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.resolveModelAttribute(context, operation).asBoolean();
        boolean useFastFail = org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.resolveModelAttribute(context, operation).asBoolean();
        CommonValidationImpl validation = new CommonValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail));
        String recoveryUsername = Constants.RECOVERY_USERNAME.resolveModelAttribute(context, operation).asString();
        ModelNode recoveryPasswordModel = Constants.RECOVERY_PASSWORD.resolveModelAttribute(context, operation);
        String recoveryPassword = recoveryPasswordModel.isDefined() ? recoveryPasswordModel.asString() : null;
        ModelNode recoverySecurityDomainModel = Constants.RECOVERY_SECURITY_DOMAIN.resolveModelAttribute(context, operation);
        String recoverySecurityDomain = recoverySecurityDomainModel.isDefined() ? recoverySecurityDomainModel.asString() : null;
        boolean noRecovery = Constants.NO_RECOVERY.resolveModelAttribute(context, operation).asBoolean();
        Recovery recovery = null;
        if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null) {
            CredentialImpl credential = null;
            credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
            Extension recoverPlugin = RaOperationUtil.extractExtension(context, operation, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
            recovery = new Recovery((Credential)credential, recoverPlugin, Boolean.valueOf(noRecovery));
        }
        ModifiableConnDef connectionDefinition = new ModifiableConnDef(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security, recovery);
        return connectionDefinition;
    }

    public static ModifiableAdminObject buildAdminObjects(OperationContext context, ModelNode operation, String poolName) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = Constants.CLASS_NAME.resolveModelAttribute(context, operation).asString();
        String jndiName = Constants.JNDINAME.resolveModelAttribute(context, operation).asString();
        boolean enabled = Constants.ENABLED.resolveModelAttribute(context, operation).asBoolean();
        boolean useJavaContext = Constants.USE_JAVA_CONTEXT.resolveModelAttribute(context, operation).asBoolean();
        ModifiableAdminObject adminObject = new ModifiableAdminObject(configProperties, className, jndiName, poolName, enabled, useJavaContext);
        return adminObject;
    }

    private static Extension extractExtension(OperationContext operationContext, ModelNode node, SimpleAttributeDefinition className, SimpleMapAttributeDefinition propertyName) throws ValidateException, OperationFailedException {
        if (node.hasDefined(className.getName())) {
            String exceptionSorterClassName = className.resolveModelAttribute(operationContext, node).asString();
            HashMap<String, String> exceptionSorterProperty = null;
            if (node.hasDefined(propertyName.getName())) {
                exceptionSorterProperty = new HashMap<String, String>(node.get(propertyName.getName()).asList().size());
                for (ModelNode property : node.get(propertyName.getName()).asList()) {
                    exceptionSorterProperty.put(property.asProperty().getName(), property.asProperty().getValue().asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }

    public static boolean deactivateIfActive(OperationContext context, String raName) throws OperationFailedException {
        boolean wasActive = false;
        ServiceName raDeploymentServiceName = ConnectorServices.getDeploymentServiceName(raName);
        Integer identifier = 0;
        if (raName.contains("->")) {
            identifier = Integer.valueOf(raName.substring(raName.indexOf("->") + 2));
            raName = raName.substring(0, raName.indexOf("->"));
        }
        if (raDeploymentServiceName != null) {
            context.removeService(raDeploymentServiceName);
            ConnectorServices.unregisterDeployment(raName, raDeploymentServiceName);
            wasActive = true;
        }
        ConnectorServices.unregisterResourceIdentifier(raName, identifier);
        ServiceName deploymentServiceName = ConnectorServices.getDeploymentServiceName(raName);
        AbstractResourceAdapterDeploymentService service = (AbstractResourceAdapterDeploymentService)context.getServiceRegistry(false).getService(deploymentServiceName);
        return wasActive;
    }

    public static void activate(OperationContext context, String raName, String rarName) throws OperationFailedException {
        ServiceController inactiveRaController;
        ServiceRegistry registry = context.getServiceRegistry(true);
        if (rarName.contains("->")) {
            rarName = rarName.substring(0, rarName.indexOf("->"));
        }
        if ((inactiveRaController = registry.getService(ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{rarName}))) == null) {
            throw new OperationFailedException("rar not yet deployed");
        }
        InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment inactive = (InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment)inactiveRaController.getValue();
        ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
        org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter raxml = (org.jboss.jca.common.api.metadata.resourceadapter.v10.ResourceAdapter)RaxmlController.getValue();
        RaServicesFactory.createDeploymentService(inactive.getRegistration(), inactive.getConnectorXmlDescriptor(), inactive.getModule(), inactive.getServiceTarget(), raName, inactive.getDeployment(), (ResourceAdapter)raxml, inactive.getResource());
    }

    public static void installRaServices(OperationContext context, ServiceVerificationHandler verificationHandler, String name, ModifiableResourceAdapter resourceAdapter) {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceController resourceAdaptersService = context.getServiceRegistry(false).getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        ServiceController controller = null;
        if (resourceAdaptersService == null) {
            controller = serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService()).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
        }
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name});
        ResourceAdapterService raService = new ResourceAdapterService(resourceAdapter);
        serviceTarget.addService(raServiceName, (Service)raService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ConnectorServices.RESOURCEADAPTERS_SERVICE, ResourceAdaptersService.ModifiableResourceAdaptors.class, raService.getResourceAdaptersInjector()).addListener((ServiceListener)verificationHandler).install();
    }
}

