/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RaRemove
implements OperationStepHandler {
    static final RaRemove INSTANCE = new RaRemove();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        final String raName = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        final String archive = model.get(Constants.ARCHIVE.getName()).asString();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("resource-adapters")) {
            for (ModelNode raNode : model.get("resource-adapters").asList()) {
                ModelNode raCompensatingNode = raNode.clone();
                compensating.get("resource-adapters").add(raCompensatingNode);
            }
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final boolean wasActive = RaOperationUtil.deactivateIfActive(context, raName);
                ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName});
                ServiceController serviceController = context.getServiceRegistry(false).getService(raServiceName);
                final ModifiableResourceAdapter resourceAdapter = serviceController != null ? (ModifiableResourceAdapter)((Object)serviceController.getValue()) : null;
                List serviceNameList = context.getServiceRegistry(false).getServiceNames();
                for (ServiceName name : serviceNameList) {
                    if (!raServiceName.isParentOf(name)) continue;
                    context.removeService(name);
                }
                context.removeService(raServiceName);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (resourceAdapter != null) {
                            RaOperationUtil.installRaServices(context, new ServiceVerificationHandler(), raName, resourceAdapter);
                            try {
                                if (wasActive) {
                                    RaOperationUtil.activate(context, raName, archive);
                                }
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

