/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.util.ParserException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementText = reader.getElementText();
        elementText = elementText == null || elementText.trim().length() == 0 ? null : elementText.trim();
        return elementText;
    }

    public String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
        return attributeString;
    }

    protected void parseExtension(XMLExtendedStreamReader reader, String enclosingTag, ModelNode operation, SimpleAttributeDefinition extensionClassName, AttributeDefinition extensionProperties) throws XMLStreamException, ParserException, ValidateException {
        Object className = null;
        Object properties = null;
        block10: for (Extension.Attribute attribute : Extension.Attribute.values()) {
            switch (attribute) {
                case CLASS_NAME: {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    String value = reader.getAttributeValue(0);
                    extensionClassName.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (reader.getLocalName().equals(enclosingTag)) {
                        return;
                    }
                    if (Extension.Tag.forName((String)reader.getLocalName()) != Extension.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (Extension.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
                            String name = reader.getAttributeValue(0);
                            String value = this.rawElementText((XMLStreamReader)reader);
                            String trimmed = value == null ? null : value.trim();
                            ModelNode node = new ModelNode();
                            if (trimmed != null) {
                                node = extensionProperties.isAllowExpression() ? ParseUtils.parsePossibleExpression((String)trimmed) : new ModelNode().set(trimmed);
                            }
                            operation.get(new String[]{extensionProperties.getName(), name}).set(node);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            if (System.getSecurityManager() == null) {
                return System.getProperty(name);
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
    }
}

