/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.io.File;
import java.util.Hashtable;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.osgi.httpservice.HttpServiceFactory;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

final class HttpServiceActivator
implements Service<StandardContext> {
    static final ServiceName JBOSS_WEB_HTTPSERVICE_FACTORY = WebSubsystemServices.JBOSS_WEB.append(new String[]{"httpservice", "factory"});
    static final String VIRTUAL_HOST = "default-host";
    static final String CONTEXT_NAME = "/httpservice";
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<PathManager> injectedPathManager = new InjectedValue();
    private final InjectedValue<VirtualHost> injectedVirtualHost = new InjectedValue();
    private final InjectedValue<HttpManagement> injectedHttpManagement = new InjectedValue();
    private final InjectedValue<WebServer> injectedWebServer = new InjectedValue();
    private final StandardContext context = new StandardContext();
    private ServiceRegistration registration;

    static ServiceController<StandardContext> addService(ServiceTarget serviceTarget) {
        HttpServiceActivator service = new HttpServiceActivator();
        ServiceBuilder builder = serviceTarget.addService(JBOSS_WEB_HTTPSERVICE_FACTORY, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.injectedPathManager);
        builder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{VIRTUAL_HOST}), VirtualHost.class, service.injectedVirtualHost);
        builder.addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.injectedWebServer);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME, HttpManagement.class, service.injectedHttpManagement);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        return builder.install();
    }

    private HttpServiceActivator() {
    }

    public void start(StartContext startContext) throws StartException {
        ServerEnvironment env = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        Host virtualHost = ((VirtualHost)this.injectedVirtualHost.getValue()).getHost();
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        WebServer webServer = (WebServer)this.injectedWebServer.getValue();
        File storageDir = new File(env.getServerTempDir() + File.separator + CONTEXT_NAME + File.separator + "httpservice-root");
        this.context.setDocBase(storageDir.getPath());
        storageDir.mkdirs();
        this.context.setPath(CONTEXT_NAME);
        this.context.addLifecycleListener((LifecycleListener)new ContextConfig());
        WebCtxLoader loader = new WebCtxLoader(this.getClass().getClassLoader());
        loader.setContainer((Container)virtualHost);
        this.context.setLoader((Loader)loader);
        this.context.setInstanceManager((InstanceManager)new LocalInstanceManager());
        this.context.addMimeMapping("html", "text/html");
        this.context.addMimeMapping("jpg", "image/jpeg");
        this.context.addMimeMapping("png", "image/png");
        this.context.addMimeMapping("gif", "image/gif");
        this.context.addMimeMapping("css", "text/css");
        this.context.addMimeMapping("js", "text/javascript");
        virtualHost.addChild((Container)this.context);
        WebLogger.WEB_LOGGER.registerWebapp(this.context.getName());
        try {
            this.context.create();
        }
        catch (Exception ex) {
            throw new StartException(WebMessages.MESSAGES.createContextFailed(), (Throwable)ex);
        }
        try {
            this.context.start();
        }
        catch (LifecycleException ex) {
            throw new StartException(WebMessages.MESSAGES.startContextFailed(), (Throwable)ex);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("provider", this.getClass().getPackage().getName());
        HttpServiceFactory serviceFactory = new HttpServiceFactory(webServer, virtualHost, this.context);
        this.registration = syscontext.registerService(HttpService.class.getName(), (Object)serviceFactory, props);
    }

    public void stop(StopContext stopContext) {
        this.registration.unregister();
        try {
            this.context.stop();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopContextFailed((Throwable)e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed((Throwable)e);
        }
    }

    public StandardContext getValue() throws IllegalStateException {
        return this.context;
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) {
            throw new UnsupportedOperationException();
        }

        public Object newInstance(String className, ClassLoader classLoader) {
            throw new UnsupportedOperationException();
        }

        public Object newInstance(Class<?> clazz) {
            throw new UnsupportedOperationException();
        }

        public void newInstance(Object instance) {
            throw new UnsupportedOperationException();
        }

        public void destroyInstance(Object instance) {
        }
    }
}

