/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.httpservice.HttpServiceImpl;
import org.jboss.as.web.WebServer;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.NamespaceException;

final class HttpServiceFactory
implements ServiceFactory {
    private final GlobalRegistry registry = GlobalRegistry.INSTANCE;
    private final WebServer webServer;
    private final Host virtualHost;
    private StandardContext context;

    HttpServiceFactory(WebServer webServer, Host virtualHost, StandardContext context) {
        this.webServer = webServer;
        this.virtualHost = virtualHost;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceRegistration registration) {
        GlobalRegistry globalRegistry = this.registry;
        synchronized (globalRegistry) {
            return new HttpServiceImpl(this.context, this.webServer, this.virtualHost, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        GlobalRegistry globalRegistry = this.registry;
        synchronized (globalRegistry) {
            HttpServiceImpl httpService = (HttpServiceImpl)service;
            for (Registration reg : this.registry.unregister(bundle)) {
                httpService.unregisterInternal(reg);
            }
        }
    }

    static class Registration {
        private final String alias;
        private final Bundle bundle;
        private final Wrapper wrapper;
        private final Type type;

        Registration(String alias, Bundle bundle, Wrapper wrapper, Type type) {
            this.alias = alias;
            this.bundle = bundle;
            this.wrapper = wrapper;
            this.type = type;
        }

        String getAlias() {
            return this.alias;
        }

        Bundle getBundle() {
            return this.bundle;
        }

        Wrapper getWrapper() {
            return this.wrapper;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "Registration [alias=" + this.alias + ",bundle=" + this.bundle + ",type=" + (Object)((Object)this.type) + "]";
        }

        static enum Type {
            SERVLET,
            RESOURCE;

        }
    }

    static class GlobalRegistry {
        static GlobalRegistry INSTANCE = new GlobalRegistry();
        private Map<String, Registration> registrations = new HashMap<String, Registration>();

        private GlobalRegistry() {
        }

        synchronized Registration register(String alias, Bundle bundle, Wrapper wrapper, Registration.Type type) throws NamespaceException {
            if (this.exists(alias)) {
                throw new NamespaceException(OSGiMessages.MESSAGES.aliasMappingAlreadyExists(alias));
            }
            OSGiLogger.LOGGER.infoRegisterHttpServiceAlias(alias);
            Registration result = new Registration(alias, bundle, wrapper, type);
            this.registrations.put(alias, result);
            return result;
        }

        synchronized boolean exists(String alias) {
            return this.registrations.get(alias) != null;
        }

        synchronized Registration unregister(String alias, Bundle bundle) {
            if (!this.exists(alias)) {
                OSGiLogger.LOGGER.errorf(OSGiMessages.MESSAGES.aliasMappingDoesNotExist(alias), new Object[0]);
                return null;
            }
            Registration reg = this.registrations.get(alias);
            if (bundle != reg.bundle) {
                OSGiLogger.LOGGER.errorf(OSGiMessages.MESSAGES.aliasMappingNotOwnedByBundle(alias, bundle), new Object[0]);
                return null;
            }
            OSGiLogger.LOGGER.infoUnregisterHttpServiceAlias(alias);
            return this.registrations.remove(reg.alias);
        }

        synchronized Set<Registration> unregister(Bundle bundle) {
            HashSet<Registration> result = new HashSet<Registration>();
            for (Registration reg : new HashSet<Registration>(this.registrations.values())) {
                if (bundle != reg.bundle) continue;
                this.registrations.remove(reg.alias);
                result.add(reg);
            }
            return result;
        }
    }
}

