/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.util.Dictionary;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.httpservice.DefaultHttpContext;
import org.jboss.as.osgi.httpservice.HttpServiceFactory;
import org.jboss.as.osgi.httpservice.ResourceServlet;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebServer;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

final class HttpServiceImpl
implements HttpService {
    private final HttpServiceFactory.GlobalRegistry registry = HttpServiceFactory.GlobalRegistry.INSTANCE;
    private final StandardContext context;
    private final WebServer webServer;
    private final Host virtualHost;
    private final Bundle bundle;

    HttpServiceImpl(StandardContext context, WebServer webServer, Host virtualHost, Bundle bundle) {
        this.virtualHost = virtualHost;
        this.webServer = webServer;
        this.context = context;
        this.bundle = bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        HttpServiceFactory.GlobalRegistry globalRegistry = this.registry;
        synchronized (globalRegistry) {
            String error = this.validateAlias(alias, false);
            if (error != null) {
                throw new NamespaceException(error);
            }
            if (httpContext == null) {
                httpContext = this.createDefaultHttpContext();
            }
            String wrapperName = alias.substring(1);
            Wrapper wrapper = this.context.createWrapper();
            wrapper.setName(wrapperName);
            wrapper.setServlet(servlet);
            wrapper.setServletClass(servlet.getClass().getName());
            if (initparams != null) {
                Enumeration keys = initparams.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String val = (String)initparams.get(key);
                    wrapper.addInitParameter(key, val);
                }
            }
            this.registerInternal(this.registry.register(alias, this.bundle, wrapper, HttpServiceFactory.Registration.Type.SERVLET));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        HttpServiceFactory.GlobalRegistry globalRegistry = this.registry;
        synchronized (globalRegistry) {
            String error = this.validateAlias(alias, false);
            if (error == null) {
                error = this.validateName(name);
            }
            if (error != null) {
                throw new NamespaceException(error);
            }
            if (httpContext == null) {
                httpContext = this.createDefaultHttpContext();
            }
            String wrapperName = alias.substring(1);
            Wrapper wrapper = this.context.createWrapper();
            wrapper.setName(wrapperName);
            wrapper.setServlet((Servlet)new ResourceServlet(name, httpContext));
            wrapper.setServletClass(ResourceServlet.class.getName());
            this.registerInternal(this.registry.register(alias, this.bundle, wrapper, HttpServiceFactory.Registration.Type.RESOURCE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String alias) {
        HttpServiceFactory.GlobalRegistry globalRegistry = this.registry;
        synchronized (globalRegistry) {
            String error = this.validateAlias(alias, true);
            if (error != null) {
                WebLogger.WEB_LOGGER.errorf(error, new Object[0]);
                return;
            }
            HttpServiceFactory.Registration reg = this.registry.unregister(alias, this.bundle);
            if (reg != null) {
                this.unregisterInternal(reg);
            }
        }
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    void registerInternal(HttpServiceFactory.Registration reg) {
        Wrapper wrapper = reg.getWrapper();
        String alias = reg.getAlias() + "/*";
        this.context.addChild((Container)wrapper);
        this.context.addServletMapping(alias, wrapper.getName());
        Mapper mapper = this.webServer.getService().getMapper();
        mapper.addWrapper(this.virtualHost.getName(), this.context.getPath(), alias, (Object)wrapper, false);
    }

    void unregisterInternal(HttpServiceFactory.Registration reg) {
        Wrapper wrapper = reg.getWrapper();
        String alias = reg.getAlias() + "/*";
        this.context.removeChild((Container)wrapper);
        this.context.removeServletMapping(alias);
        Mapper mapper = this.webServer.getService().getMapper();
        mapper.removeWrapper(this.virtualHost.getName(), this.context.getPath(), alias);
    }

    private String validateAlias(String alias, boolean exists) {
        if (alias == null || !alias.startsWith("/")) {
            return OSGiMessages.MESSAGES.invalidServletAlias(alias);
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            return OSGiMessages.MESSAGES.invalidServletAlias(alias);
        }
        if (exists && !this.registry.exists(alias)) {
            return OSGiMessages.MESSAGES.aliasMappingDoesNotExist(alias);
        }
        if (!exists && this.registry.exists(alias)) {
            return OSGiMessages.MESSAGES.aliasMappingAlreadyExists(alias);
        }
        return null;
    }

    private String validateName(String name) {
        if (name == null || name.length() > 1 && name.endsWith("/")) {
            return OSGiMessages.MESSAGES.invalidResourceName(name);
        }
        if (!name.startsWith("/")) {
            return OSGiMessages.MESSAGES.invalidResourceName(name);
        }
        return null;
    }
}

