/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;

public class DomainTransformers {
    private static final ModelVersion IGNORED_SUBSYSTEMS = ModelVersion.create((int)-1);
    private static final String JSF_SUBSYSTEM = "jsf";
    private static final PathElement JSF_EXTENSION = PathElement.pathElement((String)"extension", (String)"org.jboss.as.jsf");
    private static final ModelVersion VERSION_1_3 = ModelVersion.create((int)1, (int)3, (int)0);
    private static final ResourceTransformer IGNORED_EXTENSIONS = new IgnoreExtensionResourceTransformer();

    public static void initializeDomainRegistry(TransformerRegistry registry) {
        registry.getDomainRegistration((ModelVersionRange)VERSION_1_3).registerSubResource(JSF_EXTENSION, IGNORED_EXTENSIONS);
        registry.registerSubsystemTransformers(JSF_SUBSYSTEM, (ModelVersionRange)IGNORED_SUBSYSTEMS, ResourceTransformer.DISCARD);
    }

    static class IgnoreExtensionResourceTransformer
    implements ResourceTransformer {
        IgnoreExtensionResourceTransformer() {
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            PathElement element = address.getLastElement();
            TransformationTarget target = context.getTarget();
            ExtensionRegistry registry = target.getExtensionRegistry();
            Map subsystems = registry.getAvailableSubsystems(element.getValue());
            if (subsystems != null) {
                for (Map.Entry subsystem : subsystems.entrySet()) {
                    String name = (String)subsystem.getKey();
                    target.addSubsystemVersion(name, IGNORED_SUBSYSTEMS);
                }
            }
        }
    }
}

