/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.dmr.ModelNode;

public class ReadMasterDomainModelHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "read-master-domain-model";
    private final Transformers transformers;

    public ReadMasterDomainModelHandler(Transformers transformers) {
        this.transformers = transformers;
    }

    private Resource transformResource(OperationContext context, Resource root) throws OperationFailedException {
        return this.transformers.transformResource(Transformers.Factory.getTransformationContext((Transformers)this.transformers, (OperationContext)context), root);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        Resource untransformedRoot = context.readResource(PathAddress.EMPTY_ADDRESS, true);
        Resource root = this.transformResource(context, untransformedRoot);
        context.getResult().set(ReadMasterDomainModelHandler.describeAsNodeList(root));
        context.stepCompleted();
    }

    private static List<ModelNode> describeAsNodeList(Resource resource) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ReadMasterDomainModelHandler.describe(PathAddress.EMPTY_ADDRESS, resource, list);
        return list;
    }

    private static void describe(PathAddress base, Resource resource, List<ModelNode> nodes) {
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        if (base.size() >= 1 && base.getElement(0).getKey().equals("host")) {
            return;
        }
        ModelNode description = new ModelNode();
        description.get("domain-resource-address").set(base.toModelNode());
        description.get("domain-resource-model").set(resource.getModel());
        nodes.add(description);
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                ReadMasterDomainModelHandler.describe(base.append(new PathElement[]{entry.getPathElement()}), (Resource)entry, nodes);
            }
        }
    }
}

