/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.NoSuchElementException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerGroupAddHandler
implements OperationStepHandler {
    public static final ServerGroupAddHandler INSTANCE = new ServerGroupAddHandler();

    private ServerGroupAddHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attr : ServerGroupResourceDefinition.ADD_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
        String profile = ServerGroupResourceDefinition.PROFILE.resolveModelAttribute(context, model).asString();
        try {
            context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)ServerGroupResourceDefinition.PROFILE.getName(), (String)profile)}));
        }
        catch (NoSuchElementException e) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.unknown(ServerGroupResourceDefinition.PROFILE.getName(), profile)));
        }
        if (operation.hasDefined(ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName())) {
            String socketBindingGroup = ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.resolveModelAttribute(context, model).asString();
            try {
                context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName(), (String)socketBindingGroup)}));
            }
            catch (NoSuchElementException e) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.unknown(ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName(), socketBindingGroup)));
            }
        }
        context.stepCompleted();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

