/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationsResolverHandler;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;

public class OperationSlaveStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final Map<String, ProxyController> serverProxies;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;

    OperationSlaveStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> serverProxies, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.serverProxies = serverProxies;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        operation.get("operation-headers").remove("execute-for-coordinator");
        this.addSteps(context, operation, null, true);
        context.stepCompleted();
    }

    void addSteps(OperationContext context, ModelNode operation, ModelNode response, boolean recordResponse) throws OperationFailedException {
        PathAddress originalAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ImmutableManagementResourceRegistration originalRegistration = context.getResourceRegistration();
        if (originalRegistration == null) {
            String operationName = operation.require("operation").asString();
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.noHandlerForOperation(operationName, originalAddress)));
        }
        HostControllerExecutionSupport hostControllerExecutionSupport = HostControllerExecutionSupport.Factory.create(operation, this.localHostControllerInfo.getLocalHostName(), new LazyDomainModelProvider(context), this.ignoredDomainResourceRegistry);
        ModelNode domainOp = hostControllerExecutionSupport.getDomainOperation();
        if (domainOp != null) {
            this.addBasicStep(context, domainOp);
        }
        ServerOperationResolver resolver = new ServerOperationResolver(this.localHostControllerInfo.getLocalHostName(), this.serverProxies);
        ServerOperationsResolverHandler sorh = new ServerOperationsResolverHandler(resolver, hostControllerExecutionSupport, originalAddress, originalRegistration, response);
        context.addStep((OperationStepHandler)sorh, OperationContext.Stage.DOMAIN);
    }

    private void addBasicStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        OperationStepHandler stepHandler = context.getResourceRegistration().getOperationHandler(PathAddress.EMPTY_ADDRESS, operationName);
        if (stepHandler == null) {
            throw new OperationFailedException(new ModelNode(DomainControllerMessages.MESSAGES.noHandlerForOperation(operationName, PathAddress.pathAddress((ModelNode)operation.get("address")))));
        }
        context.addStep(operation, stepHandler, OperationContext.Stage.MODEL);
    }

    boolean isResourceExcluded(PathAddress address) {
        return this.ignoredDomainResourceRegistry.isResourceExcluded(address);
    }

    private static class LazyDomainModelProvider
    implements HostControllerExecutionSupport.DomainModelProvider {
        private final OperationContext context;
        private ModelNode domainModel;

        private LazyDomainModelProvider(OperationContext context) {
            this.context = context;
        }

        @Override
        public ModelNode getDomainModel() {
            if (this.domainModel == null) {
                this.domainModel = Resource.Tools.readModel((Resource)this.context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            }
            return this.domainModel;
        }
    }
}

