/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.NoSuchElementException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "replace-deployment";
    private final HostFileRepository fileRepository;

    public ServerGroupDeploymentReplaceHandler(HostFileRepository fileRepository) {
        if (fileRepository == null) {
            throw DomainControllerMessages.MESSAGES.nullVar("fileRepository");
        }
        this.fileRepository = fileRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource domainDeployment;
        String toReplace;
        for (AttributeDefinition def : DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateOperation(operation);
        }
        String name = ((AttributeDefinition)DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.get("name")).resolveModelAttribute(context, operation).asString();
        if (name.equals(toReplace = ((AttributeDefinition)DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_ATTRIBUTES.get("to-replace")).resolveModelAttribute(context, operation).asString())) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerMessages.MESSAGES.cannotUseSameValueForParameters(OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment"));
        }
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        PathElement replacePath = PathElement.pathElement((String)"deployment", (String)toReplace);
        try {
            domainDeployment = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
        }
        catch (NoSuchElementException e) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerMessages.MESSAGES.noDeploymentContentWithName(name));
        }
        ModelNode deployment = domainDeployment.getModel();
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined("hash")) continue;
            byte[] hash = content.require("hash").asBytes();
            this.fileRepository.getDeploymentFiles(hash);
        }
        Resource serverGroup = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        if (!serverGroup.hasChild(replacePath)) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerMessages.MESSAGES.noDeploymentContentWithName(toReplace));
        }
        Resource replaceResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{replacePath}));
        if (!serverGroup.hasChild(deploymentPath)) {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
            ModelNode deployNode = resource.getModel();
            deployNode.set(deployment);
            deployNode.remove("content");
            deployNode.get("enabled").set(true);
        } else {
            Resource deploymentResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
            if (deploymentResource.getModel().get("enabled").asBoolean()) {
                throw ServerGroupDeploymentReplaceHandler.operationFailed(DomainControllerMessages.MESSAGES.deploymentAlreadyStarted(toReplace));
            }
            deploymentResource.getModel().get("enabled").set(true);
        }
        replaceResource.getModel().get("enabled").set(false);
        context.stepCompleted();
    }

    private static OperationFailedException operationFailed(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

