/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.descriptions;

import java.io.File;
import java.net.InetAddress;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostEnvironmentResourceDescription
extends SimpleResourceDefinition {
    public static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"core-service", (String)"host-environment");
    private static final AttributeDefinition PROCESS_CONTROLLER_ADDRESS = HostEnvironmentResourceDescription.createAttributeDefinition("process-controller-address");
    private static final AttributeDefinition PROCESS_CONTROLLER_PORT = HostEnvironmentResourceDescription.createAttributeDefinition("process-controller-port", ModelType.INT);
    private static final AttributeDefinition HOST_CONTROLLER_ADDRESS = HostEnvironmentResourceDescription.createAttributeDefinition("host-controller-address");
    private static final AttributeDefinition HOST_CONTROLLER_PORT = HostEnvironmentResourceDescription.createAttributeDefinition("host-controller-port", ModelType.INT);
    private static final AttributeDefinition HOME_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("home-dir");
    private static final AttributeDefinition MODULES_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("modules-dir");
    private static final AttributeDefinition DOMAIN_BASE_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-base-dir");
    private static final AttributeDefinition DOMAIN_CONFIG_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-config-dir");
    private static final AttributeDefinition HOST_CONFIG_FILE = HostEnvironmentResourceDescription.createAttributeDefinition("host-config-file");
    private static final AttributeDefinition DOMAIN_CONFIG_FILE = HostEnvironmentResourceDescription.createAttributeDefinition("domain-config-file");
    private static final AttributeDefinition DOMAIN_CONTENT_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-content-dir");
    private static final AttributeDefinition DOMAIN_DATA_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-data-dir");
    private static final AttributeDefinition DOMAIN_LOG_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-log-dir");
    private static final AttributeDefinition DOMAIN_SERVERS_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-servers-dir");
    private static final AttributeDefinition DOMAIN_TEMP_DIR = HostEnvironmentResourceDescription.createAttributeDefinition("domain-temp-dir");
    private static final AttributeDefinition DEFAULT_JVM = HostEnvironmentResourceDescription.createAttributeDefinition("default-jvm");
    private static final AttributeDefinition IS_RESTART = HostEnvironmentResourceDescription.createAttributeDefinition("is-restart", ModelType.BOOLEAN);
    private static final AttributeDefinition BACKUP_DOMAIN_FILES = HostEnvironmentResourceDescription.createAttributeDefinition("backup-domain-files", ModelType.BOOLEAN);
    private static final AttributeDefinition USE_CACHED_DC = HostEnvironmentResourceDescription.createAttributeDefinition("use-cached-dc", ModelType.BOOLEAN);
    private static final AttributeDefinition INITIAL_RUNNING_MODE = HostEnvironmentResourceDescription.createAttributeDefinition("initial-running-mode");
    private static final AttributeDefinition QUALIFIED_HOST_NAME = HostEnvironmentResourceDescription.createAttributeDefinition("qualified-host-name");
    private static final AttributeDefinition HOST_NAME = HostEnvironmentResourceDescription.createAttributeDefinition("host-name");
    public static final AttributeDefinition[] HOST_ENV_ATTRIBUTES = new AttributeDefinition[]{PROCESS_CONTROLLER_ADDRESS, PROCESS_CONTROLLER_PORT, HOST_CONTROLLER_ADDRESS, HOST_CONTROLLER_PORT, HOME_DIR, MODULES_DIR, DOMAIN_BASE_DIR, DOMAIN_CONFIG_DIR, HOST_CONFIG_FILE, DOMAIN_CONFIG_FILE, DOMAIN_CONTENT_DIR, DOMAIN_DATA_DIR, DOMAIN_LOG_DIR, DOMAIN_SERVERS_DIR, DOMAIN_TEMP_DIR, DEFAULT_JVM, IS_RESTART, BACKUP_DOMAIN_FILES, USE_CACHED_DC, INITIAL_RUNNING_MODE, QUALIFIED_HOST_NAME, HOST_NAME};
    private final HostEnvironmentReadHandler osh;

    private HostEnvironmentResourceDescription(HostControllerEnvironment environment) {
        super(RESOURCE_PATH, HostResolver.getResolver("host.env"));
        this.osh = new HostEnvironmentReadHandler(environment);
    }

    public static HostEnvironmentResourceDescription of(HostControllerEnvironment environment) {
        return new HostEnvironmentResourceDescription(environment);
    }

    private static AttributeDefinition createAttributeDefinition(String name) {
        return HostEnvironmentResourceDescription.createAttributeDefinition(name, ModelType.STRING);
    }

    private static AttributeDefinition createAttributeDefinition(String name, ModelType type) {
        return SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)type).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : HOST_ENV_ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this.osh);
        }
    }

    private static class HostEnvironmentReadHandler
    implements OperationStepHandler {
        private final HostControllerEnvironment environment;

        public HostEnvironmentReadHandler(HostControllerEnvironment environment) {
            this.environment = environment;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            String name = operation.require("name").asString();
            if (this.equals(name, PROCESS_CONTROLLER_ADDRESS)) {
                this.set(result, this.environment.getProcessControllerAddress());
            } else if (this.equals(name, PROCESS_CONTROLLER_PORT)) {
                this.set(result, this.environment.getProcessControllerPort());
            } else if (this.equals(name, HOST_CONTROLLER_ADDRESS)) {
                this.set(result, this.environment.getHostControllerAddress());
            } else if (this.equals(name, HOST_CONTROLLER_PORT)) {
                this.set(result, this.environment.getHostControllerPort());
            } else if (this.equals(name, HOME_DIR)) {
                this.set(result, this.environment.getHomeDir());
            } else if (this.equals(name, MODULES_DIR)) {
                this.set(result, this.environment.getModulesDir());
            } else if (this.equals(name, DOMAIN_BASE_DIR)) {
                this.set(result, this.environment.getDomainBaseDir());
            } else if (this.equals(name, DOMAIN_CONFIG_DIR)) {
                this.set(result, this.environment.getDomainConfigurationDir());
            } else if (this.equals(name, HOST_CONFIG_FILE)) {
                this.set(result, this.environment.getHostConfigurationFile());
            } else if (this.equals(name, DOMAIN_CONFIG_FILE)) {
                this.set(result, this.environment.getDomainConfigurationFile());
            } else if (this.equals(name, DOMAIN_CONTENT_DIR)) {
                this.set(result, this.environment.getDomainContentDir());
            } else if (this.equals(name, DOMAIN_DATA_DIR)) {
                this.set(result, this.environment.getDomainDataDir());
            } else if (this.equals(name, DOMAIN_LOG_DIR)) {
                this.set(result, this.environment.getDomainLogDir());
            } else if (this.equals(name, DOMAIN_SERVERS_DIR)) {
                this.set(result, this.environment.getDomainServersDir());
            } else if (this.equals(name, DOMAIN_TEMP_DIR)) {
                this.set(result, this.environment.getDomainTempDir());
            } else if (this.equals(name, DEFAULT_JVM)) {
                this.set(result, this.environment.getDefaultJVM());
            } else if (this.equals(name, IS_RESTART)) {
                this.set(result, this.environment.isRestart());
            } else if (this.equals(name, BACKUP_DOMAIN_FILES)) {
                this.set(result, this.environment.isBackupDomainFiles());
            } else if (this.equals(name, USE_CACHED_DC)) {
                this.set(result, this.environment.isUseCachedDc());
            } else if (this.equals(name, INITIAL_RUNNING_MODE)) {
                this.set(result, this.environment.getInitialRunningMode().name());
            } else if (this.equals(name, QUALIFIED_HOST_NAME)) {
                this.set(result, this.environment.getQualifiedHostName());
            } else if (this.equals(name, HOST_NAME)) {
                this.set(result, this.environment.getHostName());
            }
            context.stepCompleted();
        }

        private void set(ModelNode node, int value) {
            node.set(value);
        }

        private void set(ModelNode node, boolean value) {
            node.set(value);
        }

        private void set(ModelNode node, String value) {
            if (value != null) {
                node.set(value);
            }
        }

        private void set(ModelNode node, InetAddress value) {
            if (value != null) {
                node.set(value.toString());
            }
        }

        private void set(ModelNode node, File value) {
            if (value != null) {
                node.set(value.getAbsolutePath());
            }
        }

        private void set(ModelNode node, ConfigurationFile value) {
            if (value != null) {
                this.set(node, value.getBootFile());
            }
        }

        private boolean equals(String name, AttributeDefinition attribute) {
            return name.equals(attribute.getName());
        }
    }
}

