/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelHandler;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFutureTask;

public class HostControllerRegistrationHandler
implements ManagementRequestHandlerFactory {
    private static final ModelNode READ_DOMAIN_MODEL = new ModelNode();
    private final ManagementChannelHandler handler;
    private final OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final Executor registrations;

    public HostControllerRegistrationHandler(ManagementChannelHandler handler, DomainController domainController, OperationExecutor operationExecutor, Executor registrations) {
        this.handler = handler;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.registrations = registrations;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 81: {
                RegistrationContext context = new RegistrationContext(this.domainController.getExtensionRegistry().getTransformerRegistry());
                context.activeOperation = handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), (Object)context, (ActiveOperation.CompletedCallback)context);
                return new InitiateRegistrationHandler();
            }
            case 89: {
                return new RegisterSubsystemVersionsHandler();
            }
            case 88: {
                return new CompleteRegistrationHandler();
            }
        }
        return handlers.resolveNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendResponse(ManagementRequestContext<RegistrationContext> context, byte responseType, ModelNode response) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            HostControllerRegistrationHandler.sendResponse(output, responseType, response);
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static void sendResponse(FlushableDataOutput output, byte responseType, ModelNode response) throws IOException {
        output.writeByte((int)responseType);
        if (response != null) {
            response.writeExternal((DataOutput)output);
        }
        output.writeByte(36);
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendFailedResponse(ManagementRequestContext<RegistrationContext> context, byte errorCode, String message) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            output.writeByte(34);
            output.writeByte((int)errorCode);
            output.writeUTF(message);
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static {
        READ_DOMAIN_MODEL.get("operation").set("read-master-domain-model");
        READ_DOMAIN_MODEL.get("address").setEmptyList();
        READ_DOMAIN_MODEL.protect();
    }

    static abstract class IOTask<T>
    extends AsyncFutureTask<T> {
        IOTask() {
            super(null);
        }

        abstract void sendMessage(FlushableDataOutput var1) throws IOException;

        boolean completeStep(Object result) {
            return this.setResult(result);
        }

        boolean setFailed() {
            return this.setFailed(null);
        }
    }

    private class RegistrationContext
    implements ModelController.OperationTransactionControl,
    ActiveOperation.CompletedCallback<Void> {
        private final TransformerRegistry transformerRegistry;
        private String hostName;
        private HostInfo hostInfo;
        private ManagementRequestContext<RegistrationContext> responseChannel;
        private volatile IOTask<?> task;
        private volatile boolean failed;
        private volatile Transformers transformers;
        private ActiveOperation<Void, RegistrationContext> activeOperation;
        private final AtomicBoolean completed = new AtomicBoolean();

        private RegistrationContext(TransformerRegistry transformerRegistry) {
            this.transformerRegistry = transformerRegistry;
        }

        private synchronized void initialize(String hostName, ModelNode hostInfo, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.hostName = hostName;
            this.hostInfo = HostInfo.fromModelNode(hostInfo);
            this.responseChannel = responseChannel;
        }

        public void completed(Void result) {
        }

        public void failed(Exception e) {
            this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
        }

        public void cancelled() {
        }

        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            if (this.failed) {
                transaction.rollback();
            } else {
                try {
                    this.registerHost(transaction, result);
                }
                catch (SlaveRegistrationException e) {
                    this.failed(e.getErrorCode(), e.getErrorMessage());
                }
                catch (Exception e) {
                    this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                }
                if (this.failed) {
                    transaction.rollback();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRegistration() {
            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.hostName)) {
                HostControllerRegistrationHandler.this.domainController.pingRemoteHost(this.hostName);
                boolean inter = false;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.hostName)) {
                        this.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(this.hostName));
                    }
                }
            }
            if (!this.failed) {
                try {
                    HostRegistrationStepHandler handler = new HostRegistrationStepHandler(this.transformerRegistry, this);
                    HostControllerRegistrationHandler.this.operationExecutor.execute(READ_DOMAIN_MODEL, OperationMessageHandler.logging, this, OperationAttachments.EMPTY, handler);
                }
                catch (Exception e) {
                    this.failed(e);
                    return;
                }
                this.sendCompletedMessage();
                this.responseChannel.getChannel().addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                    public void handleClose(Channel closed, IOException exception) {
                        if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(RegistrationContext.this.hostName)) {
                            HostControllerLogger.DOMAIN_LOGGER.lostConnectionToRemoteHost(RegistrationContext.this.hostName);
                        }
                        HostControllerRegistrationHandler.this.domainController.unregisterRemoteHost(RegistrationContext.this.hostName, RegistrationContext.this.getRemoteConnectionId());
                    }
                });
            }
        }

        private void processSubsystems(Transformers transformers, final ModelNode extensions) throws OperationFailedException {
            this.transformers = transformers;
            ModelNode subsystems = this.executeBlocking(new IOTask<ModelNode>(){

                @Override
                void sendMessage(FlushableDataOutput output) throws IOException {
                    HostControllerRegistrationHandler.sendResponse(output, (byte)33, extensions);
                }
            });
            if (this.failed) {
                throw new OperationFailedException(new ModelNode("failed to setup transformers"));
            }
            TransformationTarget target = transformers.getTarget();
            for (Property subsystem : subsystems.asPropertyList()) {
                String subsystemName = subsystem.getName();
                ModelNode version = subsystem.getValue();
                target.addSubsystemVersion(subsystemName, ModelVersion.fromString((String)version.asString()));
            }
        }

        protected void setSubsystems(ModelNode resolved, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.responseChannel = responseChannel;
            this.completeTask(resolved);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerHost(ModelController.OperationTransaction transaction, final ModelNode result) throws SlaveRegistrationException {
            Boolean registered = this.executeBlocking(new IOTask<Boolean>(){

                @Override
                void sendMessage(FlushableDataOutput output) throws IOException {
                    HostControllerRegistrationHandler.sendResponse(output, (byte)33, result);
                }
            });
            if (!registered.booleanValue()) {
                transaction.rollback();
                return;
            }
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                Long pingPongId = this.hostInfo.getRemoteConnectionId();
                HostControllerRegistrationHandler.this.domainController.registerRemoteHost(this.hostName, HostControllerRegistrationHandler.this.handler, this.transformers, pingPongId);
                if (this.failed) {
                    transaction.rollback();
                    return;
                }
                transaction.commit();
            }
            HostControllerLogger.DOMAIN_LOGGER.registeredRemoteSlaveHost(this.hostName, this.hostInfo.getPrettyProductName());
        }

        void completeRegistration(ManagementRequestContext<RegistrationContext> responseChannel, boolean commit) {
            this.responseChannel = responseChannel;
            this.failed |= !commit;
            this.completeTask(!this.failed);
        }

        void failed(SlaveRegistrationException.ErrorCode errorCode, String message) {
            this.failed(errorCode.getCode(), message);
        }

        void failed(byte errorCode, String message) {
            if (this.completed.compareAndSet(false, true)) {
                this.failed = true;
                IOTask<?> task = this.task;
                if (task != null) {
                    task.setFailed();
                }
                try {
                    HostControllerRegistrationHandler.sendFailedResponse(this.responseChannel, errorCode, message);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
                this.activeOperation.getResultHandler().done(null);
            }
        }

        void sendCompletedMessage() {
            if (this.completed.compareAndSet(false, true)) {
                try {
                    HostControllerRegistrationHandler.sendResponse(this.responseChannel, (byte)33, null);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
                this.activeOperation.getResultHandler().done(null);
            }
        }

        Long getRemoteConnectionId() {
            return this.hostInfo.getRemoteConnectionId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean completeTask(Object result) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                if (this.failed) {
                    return false;
                }
                if (this.task != null) {
                    return this.task.completeStep(result);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> T executeBlocking(IOTask<T> task) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                this.task = task;
                try {
                    ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)this.responseChannel.getRequestHeader());
                    FlushableDataOutput output = this.responseChannel.writeMessage((ManagementProtocolHeader)header);
                    try {
                        task.sendMessage(output);
                    }
                    catch (IOException e) {
                        this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                        throw new IllegalStateException(e);
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
                catch (IOException e) {
                    this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
            try {
                return (T)task.get();
            }
            catch (InterruptedException e) {
                this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                throw new IllegalStateException(e);
            }
        }
    }

    class HostRegistrationStepHandler
    implements OperationStepHandler {
        private final TransformerRegistry transformerRegistry;
        private final RegistrationContext registrationContext;

        protected HostRegistrationStepHandler(TransformerRegistry transformerRegistry, RegistrationContext registrationContext) {
            this.registrationContext = registrationContext;
            this.transformerRegistry = transformerRegistry;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            boolean as711;
            context.acquireControllerLock();
            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.registrationContext.hostName)) {
                String failureDescription = DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(this.registrationContext.hostName);
                this.registrationContext.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, failureDescription);
                context.getFailureDescription().set(failureDescription);
                context.stepCompleted();
                return;
            }
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"extension")}), true);
            HostInfo hostInfo = this.registrationContext.hostInfo;
            int major = hostInfo.getManagementMajorVersion();
            int minor = hostInfo.getManagementMinorVersion();
            int micro = hostInfo.getManagementMicroVersion();
            boolean bl = as711 = major == 1 && minor == 1;
            if (as711) {
                OperationFailedException failure = HostControllerMessages.MESSAGES.unsupportedManagementVersionForHost(major, minor, 1, 2);
                this.registrationContext.failed((Exception)((Object)failure));
                throw failure;
            }
            TransformationTargetImpl target = TransformationTargetImpl.create((TransformerRegistry)this.transformerRegistry, (ModelVersion)ModelVersion.create((int)major, (int)minor, (int)micro), Collections.emptyMap(), (TransformationTarget.IgnoredTransformationRegistry)hostInfo, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.HOST);
            Transformers transformers = Transformers.Factory.create((TransformationTarget)target);
            ModelNode extensions = new ModelNode();
            Resource transformed = transformers.transformResource(Transformers.Factory.getTransformationContext((TransformationTarget)target, (OperationContext)context), root);
            Set resources = transformed.getChildren("extension");
            for (Resource.ResourceEntry entry : resources) {
                extensions.add(entry.getName());
            }
            if (!extensions.isDefined()) {
                throw new OperationFailedException(extensions);
            }
            this.registrationContext.processSubsystems(transformers, extensions);
            ReadMasterDomainModelHandler handler = new ReadMasterDomainModelHandler(transformers);
            context.addStep(READ_DOMAIN_MODEL, (OperationStepHandler)handler, OperationContext.Stage.MODEL);
            context.stepCompleted();
        }
    }

    static class CompleteRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        CompleteRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            String message = input.readUTF();
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.completeRegistration(context, status == 33);
        }
    }

    class RegisterSubsystemVersionsHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        RegisterSubsystemVersionsHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            ModelNode subsystems = new ModelNode();
            subsystems.readExternal(input);
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            if (status == 33) {
                registration.setSubsystems(subsystems, context);
            } else {
                registration.setSubsystems(null, context);
            }
        }
    }

    class InitiateRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        InitiateRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            String hostName = input.readUTF();
            ModelNode hostInfo = new ModelNode();
            hostInfo.readExternal(input);
            final RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.initialize(hostName, hostInfo, (ManagementRequestContext<RegistrationContext>)context);
            if (HostControllerRegistrationHandler.this.domainController.getCurrentRunningMode() == RunningMode.ADMIN_ONLY) {
                registration.failed(SlaveRegistrationException.ErrorCode.MASTER_IS_ADMIN_ONLY, DomainControllerMessages.MESSAGES.adminOnlyModeCannotAcceptSlaves(RunningMode.ADMIN_ONLY));
                return;
            }
            if (!HostControllerRegistrationHandler.this.domainController.getLocalHostInfo().isMasterDomainController()) {
                registration.failed(SlaveRegistrationException.ErrorCode.HOST_IS_NOT_MASTER, DomainControllerMessages.MESSAGES.slaveControllerCannotAcceptOtherSlaves());
                return;
            }
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<RegistrationContext>(){

                public void execute(ManagementRequestContext<RegistrationContext> context) throws Exception {
                    registration.processRegistration();
                }
            }, HostControllerRegistrationHandler.this.registrations);
        }
    }

    public static interface OperationExecutor {
        public ModelNode execute(ModelNode var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationAttachments var4, OperationStepHandler var5);
    }
}

