/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class JVMEnvironmentVariableAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add-item-to-environment-variables-list";
    static final JVMEnvironmentVariableAddHandler INSTANCE = new JVMEnvironmentVariableAddHandler();
    static final SimpleAttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    private static final SimpleAttributeDefinition VALUE = SimpleAttributeDefinitionBuilder.create((String)"value", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("add-item-to-environment-variables-list", HostResolver.getResolver("jvm")).addParameter((AttributeDefinition)NAME).addParameter((AttributeDefinition)VALUE).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        String name = NAME.validateOperation(operation).asString();
        String value = VALUE.validateOperation(operation).asString();
        ModelNode variables = model.get("environment-variables");
        if (variables.isDefined()) {
            for (ModelNode varNode : variables.asList()) {
                if (!varNode.asProperty().getName().equals(name)) continue;
                throw HostControllerMessages.MESSAGES.envVariableAlreadyExists(varNode.asProperty().getName());
            }
        }
        model.get("environment-variables").add(name, value);
        context.stepCompleted();
    }
}

