/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.model.jvm.JVMEnvironmentVariableAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class JVMEnvironmentVariableRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove-item-from-environment-variables-list";
    static final JVMEnvironmentVariableRemoveHandler INSTANCE = new JVMEnvironmentVariableRemoveHandler();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-item-from-environment-variables-list", HostResolver.getResolver("jvm")).addParameter((AttributeDefinition)JVMEnvironmentVariableAddHandler.NAME).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        String name = JVMEnvironmentVariableAddHandler.NAME.validateOperation(operation).asString();
        ModelNode variables = model.get("environment-variables");
        if (variables.isDefined()) {
            ModelNode values = variables.clone();
            model.get("environment-variables").setEmptyList();
            for (Property value : values.asPropertyList()) {
                if (value.getName().equals(name)) continue;
                model.get("environment-variables").add(value.getName(), value.getValue());
            }
        }
        context.stepCompleted();
    }
}

