/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.dmr.ModelNode;

public abstract class ServerRestartRequiredServerConfigWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler GROUP_INSTANCE = new GroupHandler();
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler SOCKET_BINDING_GROUP_INSTANCE = new SocketBindingGroupHandler();
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler SOCKET_BINDING_PORT_OFFSET_INSTANCE = new SocketBindingPortOffsetHandler();
    private static StringLengthValidator STRING_VALIDATOR = new StringLengthValidator(1, false);

    public ServerRestartRequiredServerConfigWriteAttributeHandler(ParameterValidator validator) {
        super(validator);
    }

    protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        if (newValue.equals(currentValue)) {
            ServerOperationResolver.addToDontPropagateToServersAttachment(context, operation);
        }
        this.validateReferencedNewValueExisits(context, newValue);
        context.stepCompleted();
    }

    protected abstract void validateReferencedNewValueExisits(OperationContext var1, ModelNode var2) throws OperationFailedException;

    private static class SocketBindingPortOffsetHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        static final IntRangeValidator VALIDATOR = new IntRangeValidator(0, true);

        public SocketBindingPortOffsetHandler() {
            super((ParameterValidator)VALIDATOR);
        }

        @Override
        protected void validateReferencedNewValueExisits(OperationContext context, ModelNode value) throws OperationFailedException {
        }
    }

    private static class SocketBindingGroupHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        public SocketBindingGroupHandler() {
            super((ParameterValidator)STRING_VALIDATOR);
        }

        @Override
        protected void validateReferencedNewValueExisits(OperationContext context, ModelNode value) throws OperationFailedException {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
            if (!context.isBooting() && root.getChild(PathElement.pathElement((String)"socket-binding-group", (String)value.asString())) == null) {
                throw HostControllerMessages.MESSAGES.noSocketBindingGroupCalled(value.asString());
            }
        }
    }

    private static class GroupHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        public GroupHandler() {
            super((ParameterValidator)STRING_VALIDATOR);
        }

        @Override
        protected void validateReferencedNewValueExisits(OperationContext context, ModelNode value) throws OperationFailedException {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
            if (!context.isBooting() && root.getChild(PathElement.pathElement((String)"server-group", (String)value.asString())) == null) {
                throw HostControllerMessages.MESSAGES.noServerGroupCalled(value.asString());
            }
        }
    }
}

