/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.dmr.ModelNode;

public class ServerStopHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "stop";
    public static final OperationDefinition DEFINITION = ServerStartHandler.getOperationDefinition("stop");
    private final ServerInventory serverInventory;

    public static ModelNode getStopServerOperation(String serverName) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)new ModelNode());
        op.get("name").set(serverName);
        return op;
    }

    public ServerStopHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final boolean blocking = operation.get("blocking").asBoolean(false);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerStatus status = ServerStopHandler.this.serverInventory.stopServer(serverName, -1, blocking);
                context.getResult().set(status.toString());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

