/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessInfo;
import org.jboss.dmr.ModelNode;

public class StartServersHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "start-servers";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("start-servers", null).setPrivateEntry().build();
    private final ServerInventory serverInventory;
    private final HostControllerEnvironment hostControllerEnvironment;
    private final HostRunningModeControl runningModeControl;

    public StartServersHandler(HostControllerEnvironment hostControllerEnvironment, ServerInventory serverInventory, HostRunningModeControl runningModeControl) {
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.serverInventory = serverInventory;
        this.runningModeControl = runningModeControl;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!context.isBooting()) {
            throw new OperationFailedException(new ModelNode().set(HostControllerMessages.MESSAGES.invocationNotAllowedAfterBoot(operation.require("operation"))));
        }
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(new ModelNode(HostControllerMessages.MESSAGES.cannotStartServersInvalidMode(context.getRunningMode())));
        }
        final ModelNode domainModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                ModelNode hostModel = Resource.Tools.readModel((Resource)resource);
                if (hostModel.hasDefined("server-config")) {
                    ModelNode servers = hostModel.get("server-config").clone();
                    if (StartServersHandler.this.hostControllerEnvironment.isRestart() || StartServersHandler.this.runningModeControl.getRestartMode() == RestartMode.HC_ONLY) {
                        StartServersHandler.this.restartedHcStartOrReconnectServers(servers, domainModel);
                    } else {
                        StartServersHandler.this.cleanStartServers(servers, domainModel);
                    }
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }

    private void cleanStartServers(ModelNode servers, ModelNode domainModel) {
        for (String serverName : servers.keys()) {
            if (!servers.get(new String[]{serverName, "auto-start"}).asBoolean(true)) continue;
            try {
                this.serverInventory.startServer(serverName, domainModel);
            }
            catch (Exception e) {
                HostControllerLogger.ROOT_LOGGER.failedToStartServer(e, serverName);
            }
        }
    }

    private void restartedHcStartOrReconnectServers(ModelNode servers, ModelNode domainModel) {
        Map<String, ProcessInfo> processInfos = this.serverInventory.determineRunningProcesses();
        for (String serverName : servers.keys()) {
            ProcessInfo info = processInfos.get(this.serverInventory.getServerProcessName(serverName));
            boolean auto = servers.get(new String[]{serverName, "auto-start"}).asBoolean(true);
            if (info == null && auto) {
                try {
                    this.serverInventory.startServer(serverName, domainModel);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.failedToStartServer(e, serverName);
                }
                continue;
            }
            if (info == null) continue;
            this.serverInventory.reconnectServer(serverName, domainModel, info.isRunning(), info.isStopping());
        }
    }
}

