/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementAddHandler;
import org.jboss.as.host.controller.operations.NativeManagementWriteAttributeHandler;
import org.jboss.dmr.ModelType;

public class NativeManagementResourceDefinition
extends SimpleResourceDefinition {
    private static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"management-interface", (String)"native-interface");
    public static final SimpleAttributeDefinition SECURITY_REALM = new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition INTERFACE = new SimpleAttributeDefinitionBuilder("interface", ModelType.STRING, false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition NATIVE_PORT = new SimpleAttributeDefinitionBuilder("port", ModelType.INT, false).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, false, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{INTERFACE, NATIVE_PORT, SECURITY_REALM};
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementResourceDefinition(LocalHostControllerInfoImpl hostControllerInfo) {
        super(RESOURCE_PATH, (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver("core", "management", "native-interface"), (AbstractAddStepHandler)new NativeManagementAddHandler(hostControllerInfo), null, OperationEntry.Flag.RESTART_NONE, null);
        this.hostControllerInfo = hostControllerInfo;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTE_DEFINITIONS) {
            resourceRegistration.registerReadWriteAttribute(attr, null, NativeManagementWriteAttributeHandler.INSTANCE);
        }
    }
}

