/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.KeyManagerAttributeDefinition;
import org.jboss.as.security.KeyStoreAttributeDefinition;
import org.jboss.as.security.SecurityDomainReloadAddHandler;
import org.jboss.as.security.SecurityDomainReloadRemoveHandler;
import org.jboss.as.security.SecurityDomainReloadWriteHandler;
import org.jboss.as.security.SecurityExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JSSEResourceDefinition
extends SimpleResourceDefinition {
    public static final JSSEResourceDefinition INSTANCE = new JSSEResourceDefinition();
    public static final KeyStoreAttributeDefinition KEYSTORE = new KeyStoreAttributeDefinition("keystore");
    public static final KeyStoreAttributeDefinition TRUSTSTORE = new KeyStoreAttributeDefinition("truststore");
    public static final KeyManagerAttributeDefinition KEYMANAGER = new KeyManagerAttributeDefinition("key-manager");
    public static final KeyManagerAttributeDefinition TRUSTMANAGER = new KeyManagerAttributeDefinition("trust-manager");
    public static final SimpleAttributeDefinition CLIENT_ALIAS = new SimpleAttributeDefinitionBuilder("client-alias", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition SERVER_ALIAS = new SimpleAttributeDefinitionBuilder("server-alias", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition SERVICE_AUTH_TOKEN = new SimpleAttributeDefinitionBuilder("service-auth-token", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition CLIENT_AUTH = new SimpleAttributeDefinitionBuilder("client-auth", ModelType.BOOLEAN, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition PROTOCOLS = new SimpleAttributeDefinitionBuilder("protocols", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition CIPHER_SUITES = new SimpleAttributeDefinitionBuilder("cipher-suites", ModelType.STRING, true).setAllowExpression(true).build();
    public static final PropertiesAttributeDefinition ADDITIONAL_PROPERTIES = new PropertiesAttributeDefinition("additional-properties", "property", true);

    private JSSEResourceDefinition() {
        super(PathElement.pathElement((String)"jsse", (String)"classic"), SecurityExtension.getResourceDescriptionResolver("jsse"), (OperationStepHandler)JSSEResourceDefinitionAdd.INSTANCE, (OperationStepHandler)new SecurityDomainReloadRemoveHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)KEYSTORE, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler(KEYSTORE));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)TRUSTSTORE, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler(TRUSTSTORE));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)KEYMANAGER, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler(KEYMANAGER));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)TRUSTMANAGER, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler(TRUSTMANAGER));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CLIENT_ALIAS, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)CLIENT_ALIAS));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SERVER_ALIAS, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)SERVER_ALIAS));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SERVICE_AUTH_TOKEN, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)SERVICE_AUTH_TOKEN));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CLIENT_AUTH, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)CLIENT_AUTH));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PROTOCOLS, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)PROTOCOLS));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CIPHER_SUITES, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)CIPHER_SUITES));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ADDITIONAL_PROPERTIES, null, (OperationStepHandler)new SecurityDomainReloadWriteHandler((AttributeDefinition)ADDITIONAL_PROPERTIES));
    }

    static class JSSEResourceDefinitionAdd
    extends SecurityDomainReloadAddHandler {
        static final JSSEResourceDefinitionAdd INSTANCE = new JSSEResourceDefinitionAdd();

        JSSEResourceDefinitionAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            KEYSTORE.validateAndSet(operation, model);
            TRUSTSTORE.validateAndSet(operation, model);
            KEYMANAGER.validateAndSet(operation, model);
            TRUSTMANAGER.validateAndSet(operation, model);
            CLIENT_ALIAS.validateAndSet(operation, model);
            SERVER_ALIAS.validateAndSet(operation, model);
            SERVICE_AUTH_TOKEN.validateAndSet(operation, model);
            CLIENT_AUTH.validateAndSet(operation, model);
            PROTOCOLS.validateAndSet(operation, model);
            CIPHER_SUITES.validateAndSet(operation, model);
            ADDITIONAL_PROPERTIES.validateAndSet(operation, model);
        }
    }
}

