/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.security.SecurityMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class KeyManagerAttributeDefinition
extends AttributeDefinition {
    private static final ParameterValidator keyManagerValidator;
    private static final ParameterValidator fieldValidator;
    private static final String[] FIELDS;

    protected KeyManagerAttributeDefinition(String name) {
        super(name, null, null, ModelType.OBJECT, true, false, null, keyManagerValidator, null, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    }

    public void marshallAsAttribute(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.isMarshallable(resourceModel, marshallDefault)) {
            if ((resourceModel = resourceModel.get(this.getName())).hasDefined("algorithm")) {
                writer.writeAttribute(this.getName() + "-factory-" + "algorithm", resourceModel.get("algorithm").asString());
            }
            if (resourceModel.hasDefined("provider")) {
                writer.writeAttribute(this.getName() + "-factory-" + "provider", resourceModel.get("provider").asString());
            }
        }
    }

    public static ModelNode parseField(String name, String value, XMLStreamReader reader) throws XMLStreamException {
        String trimmed = value == null ? null : value.trim();
        ModelNode node = trimmed != null ? new ModelNode().set(ParseUtils.parsePossibleExpression((String)trimmed)) : new ModelNode();
        try {
            fieldValidator.validateParameter(name, node);
        }
        catch (OperationFailedException e) {
            throw SecurityMessages.MESSAGES.xmlStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
        return node;
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        ModelNode validateOp = operationObject;
        if (operationObject.hasDefined(this.getName())) {
            validateOp = operationObject.clone();
            ModelNode attr = validateOp.get(this.getName());
            for (String field : FIELDS) {
                ModelNode fieldNode = attr.get(field);
                if (fieldNode.getType() != ModelType.STRING) continue;
                fieldNode.set(ParseUtils.parsePossibleExpression((String)fieldNode.asString()));
            }
        }
        return super.validateOperation(validateOp);
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    private void addAttributeValueTypeDescription(ModelNode result, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(result);
        valueType.get(new String[]{"algorithm", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"algorithm"}));
        valueType.get(new String[]{"provider", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"provider"}));
    }

    private void addOperationParameterValueTypeDescription(ModelNode result, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(result);
        valueType.get(new String[]{"algorithm", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"algorithm"}));
        valueType.get(new String[]{"provider", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"provider"}));
    }

    private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
        ModelNode valueType = parent.get("value-type");
        ModelNode password = valueType.get("algorithm");
        password.get("description");
        password.get("type").set(ModelType.STRING);
        password.get("nillable").set(true);
        password.get("expressions-allowed").set(true);
        ModelNode provider = valueType.get("provider");
        provider.get("description");
        provider.get("type").set(ModelType.STRING);
        provider.get("nillable").set(true);
        provider.get("expressions-allowed").set(true);
        return valueType;
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        throw SecurityMessages.MESSAGES.unsupportedOperationExceptionUseResourceDesc();
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        throw SecurityMessages.MESSAGES.unsupportedOperationExceptionUseResourceDesc();
    }

    public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw SecurityMessages.MESSAGES.unsupportedOperation();
    }

    static {
        FIELDS = new String[]{"algorithm", "provider"};
        ParametersValidator delegate = new ParametersValidator();
        for (String field : FIELDS) {
            delegate.registerValidator(field, (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, true));
        }
        keyManagerValidator = new ParametersOfValidator(delegate);
        fieldValidator = delegate;
    }
}

