/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.RealmRole;
import org.jboss.as.domain.management.security.RealmUser;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class RealmDirectLoginModule
extends UsernamePasswordLoginModule {
    private static final String DEFAULT_REALM = "ApplicationRealm";
    private static final String REALM_OPTION = "realm";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"realm"};
    private SecurityRealm securityRealm;
    private AuthenticationMechanism chosenMech;
    private ValidationMode validationMode;
    private UsernamePasswordHashUtil hashUtil;
    private AuthorizingCallbackHandler callbackHandler;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        String realm = options.containsKey(REALM_OPTION) ? (String)options.get(REALM_OPTION) : DEFAULT_REALM;
        ServiceController controller = RealmDirectLoginModule.currentServiceContainer().getService(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realm}));
        if (controller != null) {
            this.securityRealm = (SecurityRealm)controller.getValue();
        }
        if (this.securityRealm == null) {
            throw SecurityMessages.MESSAGES.realmNotFound(realm);
        }
        Set authMechs = this.securityRealm.getSupportedAuthenticationMechanisms();
        if (authMechs.contains(AuthenticationMechanism.DIGEST)) {
            this.chosenMech = AuthenticationMechanism.DIGEST;
        } else if (authMechs.contains(AuthenticationMechanism.PLAIN)) {
            this.chosenMech = AuthenticationMechanism.PLAIN;
        } else {
            throw SecurityMessages.MESSAGES.noPasswordValidationAvailable(realm);
        }
        Map mechOpts = this.securityRealm.getMechanismConfig(this.chosenMech);
        if (mechOpts.containsKey("org.jboss.as.domain.management.verify_password_callback_supported") && Boolean.parseBoolean((String)mechOpts.get("org.jboss.as.domain.management.verify_password_callback_supported"))) {
            this.validationMode = ValidationMode.VALIDATION;
        } else if (this.chosenMech == AuthenticationMechanism.DIGEST) {
            boolean plainTextDigest = true;
            if (mechOpts.containsKey("org.jboss.as.domain.management.digest.plain_text") && Boolean.parseBoolean((String)mechOpts.get("org.jboss.as.domain.management.digest.plain_text"))) {
                this.validationMode = ValidationMode.PASSWORD;
            } else {
                this.validationMode = ValidationMode.DIGEST;
                try {
                    this.hashUtil = new UsernamePasswordHashUtil();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
            }
        } else {
            this.validationMode = ValidationMode.PASSWORD;
        }
    }

    protected String createPasswordHash(String username, String password, String digestOption) throws LoginException {
        throw new UnsupportedOperationException();
    }

    protected String getUsersPassword() throws LoginException {
        if (this.validationMode == ValidationMode.VALIDATION) {
            return null;
        }
        RealmCallback rcb = new RealmCallback("Realm", this.securityRealm.getName());
        NameCallback ncb = new NameCallback("User Name", this.getUsername());
        String password = null;
        switch (this.validationMode) {
            case DIGEST: {
                DigestHashCallback dhc = new DigestHashCallback("Digest");
                this.handle(new Callback[]{rcb, ncb, dhc});
                password = dhc.getHexHash();
                break;
            }
            case PASSWORD: {
                PasswordCallback pcb = new PasswordCallback("Password", false);
                this.handle(new Callback[]{rcb, ncb, pcb});
                password = String.valueOf(pcb.getPassword());
            }
        }
        return password;
    }

    private void handle(Callback[] callbacks) throws LoginException {
        try {
            AuthorizingCallbackHandler callbackHandler = this.getCallbackHandler();
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw SecurityMessages.MESSAGES.failureCallingSecurityRealm(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw SecurityMessages.MESSAGES.failureCallingSecurityRealm(e.getMessage());
        }
    }

    private AuthorizingCallbackHandler getCallbackHandler() {
        if (this.callbackHandler == null) {
            this.callbackHandler = this.securityRealm.getAuthorizingCallbackHandler(this.chosenMech);
        }
        return this.callbackHandler;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        switch (this.validationMode) {
            case DIGEST: {
                String inputHashed = this.hashUtil.generateHashedHexURP(this.getUsername(), this.securityRealm.getName(), inputPassword.toCharArray());
                return expectedPassword.equals(inputHashed);
            }
            case PASSWORD: {
                return expectedPassword.equals(inputPassword);
            }
            case VALIDATION: {
                RealmCallback rcb = new RealmCallback("Realm", this.securityRealm.getName());
                NameCallback ncb = new NameCallback("User Name", this.getUsername());
                VerifyPasswordCallback vpc = new VerifyPasswordCallback(inputPassword);
                try {
                    this.handle(new Callback[]{rcb, ncb, vpc});
                    return vpc.isVerified();
                }
                catch (LoginException e) {
                    return false;
                }
            }
        }
        return false;
    }

    protected Group[] getRoleSets() throws LoginException {
        HashSet<RealmUser> principalCol = new HashSet<RealmUser>();
        principalCol.add(new RealmUser(this.getUsername()));
        try {
            AuthorizingCallbackHandler callbackHandler = this.getCallbackHandler();
            SubjectUserInfo sui = callbackHandler.createSubjectUserInfo(principalCol);
            SimpleGroup sg = new SimpleGroup("Roles");
            Set<RealmRole> roles = sui.getSubject().getPrincipals(RealmRole.class);
            for (RealmRole current : roles) {
                sg.addMember(this.createIdentity(current.getName()));
            }
            return new Group[]{sg};
        }
        catch (Exception e) {
            throw SecurityMessages.MESSAGES.failureCallingSecurityRealm(e.getMessage());
        }
    }

    private static ServiceContainer currentServiceContainer() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }

    private static enum ValidationMode {
        DIGEST,
        PASSWORD,
        VALIDATION;

    }
}

