/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.transaction.TransactionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.security.ModuleFlag;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.JBossJSSESecurityDomain;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.security.plugins.TransactionManagerLocator;

class SecurityDomainAdd
extends AbstractAddStepHandler {
    static final String OPERATION_NAME = "add";
    private static final String CACHE_CONTAINER_NAME = "security";
    static final SecurityDomainAdd INSTANCE = new SecurityDomainAdd();

    static final ModelNode getRecreateOperation(ModelNode address, ModelNode securityDomain) {
        return Util.getOperation((String)OPERATION_NAME, (ModelNode)address, (ModelNode)securityDomain);
    }

    private SecurityDomainAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        SecurityDomainResourceDefinition.CACHE_TYPE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String securityDomain = address.getLastElement().getValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                SecurityDomainAdd.this.launchServices(context, securityDomain, Resource.Tools.readModel((Resource)resource), verificationHandler, newControllers);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    void launchServices(OperationContext context, String securityDomain, ModelNode model) throws OperationFailedException {
        this.launchServices(context, securityDomain, model, null, null);
    }

    public void launchServices(OperationContext context, String securityDomain, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ApplicationPolicy applicationPolicy = this.createApplicationPolicy(context, securityDomain, model);
        JSSESecurityDomain jsseSecurityDomain = this.createJSSESecurityDomain(context, securityDomain, model);
        String cacheType = SecurityDomainAdd.getAuthenticationCacheType(model);
        SecurityDomainService securityDomainService = new SecurityDomainService(securityDomain, applicationPolicy, jsseSecurityDomain, cacheType);
        ServiceTarget target = context.getServiceTarget();
        Injector<TransactionManager> transactionManagerInjector = new Injector<TransactionManager>(){

            public void inject(TransactionManager value) throws InjectionException {
                TransactionManagerLocator.setTransactionManager((TransactionManager)value);
            }

            public void uninject() {
            }
        };
        ServiceBuilder builder = target.addService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), (Service)securityDomainService).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, securityDomainService.getSecurityManagementInjector()).addDependency(JaasConfigurationService.SERVICE_NAME, Configuration.class, securityDomainService.getConfigurationInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TransactionManagerService.SERVICE_NAME, TransactionManager.class, (Injector)transactionManagerInjector);
        if ("infinispan".equals(cacheType)) {
            builder.addDependency(EmbeddedCacheManagerService.getServiceName((String)CACHE_CONTAINER_NAME), EmbeddedCacheManager.class, securityDomainService.getCacheManagerInjector());
        }
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    private ApplicationPolicy createApplicationPolicy(OperationContext context, String securityDomain, ModelNode model) throws OperationFailedException {
        ApplicationPolicy applicationPolicy = new ApplicationPolicy(securityDomain);
        boolean create = this.processClassicAuth(context, securityDomain, model, applicationPolicy);
        create |= this.processJASPIAuth(context, securityDomain, model, applicationPolicy);
        create |= this.processAuthorization(context, securityDomain, model, applicationPolicy);
        create |= this.processACL(context, securityDomain, model, applicationPolicy);
        create |= this.processAudit(context, securityDomain, model, applicationPolicy);
        create |= this.processIdentityTrust(context, securityDomain, model, applicationPolicy);
        return (create |= this.processMapping(context, securityDomain, model, applicationPolicy)) ? applicationPolicy : null;
    }

    private boolean processMapping(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "mapping", "classic")) == null) {
            return false;
        }
        List modules = node.get("mapping-modules").asList();
        for (ModelNode module : modules) {
            MappingInfo mappingInfo = new MappingInfo(securityDomain);
            String codeName = this.extractCode(module, ModulesMap.MAPPING_MAP);
            String mappingType = module.hasDefined("type") ? module.get("type").asString() : MappingType.ROLE.toString();
            Map<String, Object> options = this.extractOptions(context, module);
            MappingModuleEntry entry = new MappingModuleEntry(codeName, options, mappingType);
            mappingInfo.add((Object)entry);
            applicationPolicy.setMappingInfo(mappingType, mappingInfo);
            String moduleName = module.get("module").asString();
            if (!module.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            mappingInfo.setJBossModuleName(moduleName);
        }
        return true;
    }

    private boolean processIdentityTrust(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "identity-trust", "classic")) == null) {
            return false;
        }
        IdentityTrustInfo identityTrustInfo = new IdentityTrustInfo(securityDomain);
        List modules = node.get("trust-modules").asList();
        for (ModelNode module : modules) {
            String codeName = module.require("code").asString();
            ControlFlag controlFlag = ControlFlag.valueOf((String)module.require("flag").asString());
            Map<String, Object> options = this.extractOptions(context, module);
            IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(codeName, options);
            entry.setControlFlag(controlFlag);
            identityTrustInfo.add((Object)entry);
            String moduleName = module.get("module").asString();
            if (!module.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            identityTrustInfo.setJBossModuleName(moduleName);
        }
        applicationPolicy.setIdentityTrustInfo(identityTrustInfo);
        return true;
    }

    private boolean processAudit(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "audit", "classic")) == null) {
            return false;
        }
        AuditInfo auditInfo = new AuditInfo(securityDomain);
        List modules = node.get("provider-modules").asList();
        for (ModelNode module : modules) {
            String codeName = module.require("code").asString();
            Map<String, Object> options = this.extractOptions(context, module);
            AuditProviderEntry entry = new AuditProviderEntry(codeName, options);
            auditInfo.add((Object)entry);
            String moduleName = module.get("module").asString();
            if (!module.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            auditInfo.setJBossModuleName(moduleName);
        }
        applicationPolicy.setAuditInfo(auditInfo);
        return true;
    }

    private boolean processACL(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "acl", "classic")) == null) {
            return false;
        }
        ACLInfo aclInfo = new ACLInfo(securityDomain);
        List modules = node.get("acl-modules").asList();
        for (ModelNode module : modules) {
            String codeName = module.require("code").asString();
            ControlFlag controlFlag = ControlFlag.valueOf((String)module.require("flag").asString());
            Map<String, Object> options = this.extractOptions(context, module);
            ACLProviderEntry entry = new ACLProviderEntry(codeName, options);
            entry.setControlFlag(controlFlag);
            aclInfo.add((Object)entry);
            String moduleName = module.get("module").asString();
            if (!module.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            aclInfo.setJBossModuleName(moduleName);
        }
        applicationPolicy.setAclInfo(aclInfo);
        return true;
    }

    private boolean processAuthorization(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "authorization", "classic")) == null) {
            return false;
        }
        AuthorizationInfo authzInfo = new AuthorizationInfo(securityDomain);
        List modules = node.get("policy-modules").asList();
        for (ModelNode module : modules) {
            String codeName = this.extractCode(module, ModulesMap.AUTHORIZATION_MAP);
            ControlFlag controlFlag = ControlFlag.valueOf((String)module.require("flag").asString());
            Map<String, Object> options = this.extractOptions(context, module);
            AuthorizationModuleEntry authzModuleEntry = new AuthorizationModuleEntry(codeName, options);
            authzModuleEntry.setControlFlag(controlFlag);
            authzInfo.add((Object)authzModuleEntry);
            String moduleName = module.get("module").asString();
            if (!module.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            authzInfo.setJBossModuleName(moduleName);
        }
        applicationPolicy.setAuthorizationInfo(authzInfo);
        return true;
    }

    private boolean processJASPIAuth(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "authentication", "jaspi")) == null) {
            return false;
        }
        JASPIAuthenticationInfo authenticationInfo = new JASPIAuthenticationInfo(securityDomain);
        HashMap<String, LoginModuleStackHolder> holders = new HashMap<String, LoginModuleStackHolder>();
        List stacks = node.get("login-module-stack").asPropertyList();
        for (Property stack : stacks) {
            String name = stack.getName();
            ModelNode stackNode = stack.getValue();
            final LoginModuleStackHolder holder = new LoginModuleStackHolder(name, null);
            holders.put(name, holder);
            authenticationInfo.add(holder);
            if (!stackNode.hasDefined("login-modules")) continue;
            this.processLoginModules(context, stackNode.get("login-modules"), (BaseAuthenticationInfo)authenticationInfo, new LoginModuleContainer(){

                @Override
                public void addAppConfigurationEntry(AppConfigurationEntry entry) {
                    holder.addAppConfigurationEntry(entry);
                }
            });
        }
        List authModules = node.get("auth-modules").asList();
        for (ModelNode authModule : authModules) {
            String code = this.extractCode(authModule, ModulesMap.AUTHENTICATION_MAP);
            String loginStackRef = null;
            if (authModule.hasDefined("login-module-stack-ref")) {
                loginStackRef = authModule.get("login-module-stack-ref").asString();
            }
            Map<String, Object> options = this.extractOptions(context, authModule);
            AuthModuleEntry entry = new AuthModuleEntry(code, options, loginStackRef);
            if (authModule.hasDefined("flag")) {
                entry.setControlFlag(ControlFlag.valueOf((String)authModule.get("flag").asString()));
            }
            if (loginStackRef != null) {
                if (!holders.containsKey(loginStackRef)) {
                    throw SecurityMessages.MESSAGES.loginModuleStackIllegalArgument(loginStackRef);
                }
                entry.setLoginModuleStackHolder((LoginModuleStackHolder)holders.get(loginStackRef));
            }
            authenticationInfo.add(entry);
            String moduleName = authModule.get("module").asString();
            if (!authModule.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            authenticationInfo.setJBossModuleName(moduleName);
        }
        applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        return true;
    }

    private String extractCode(ModelNode node, Map<String, String> substitutions) {
        String code = node.require("code").asString();
        if (substitutions.containsKey(code)) {
            code = substitutions.get(code);
        }
        return code;
    }

    private ModelNode peek(ModelNode node, String ... args) {
        for (String arg : args) {
            if (!node.hasDefined(arg)) {
                return null;
            }
            node = node.get(arg);
        }
        return node;
    }

    private boolean processClassicAuth(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "authentication", "classic")) == null) {
            return false;
        }
        final AuthenticationInfo authenticationInfo = new AuthenticationInfo(securityDomain);
        if (node.hasDefined("login-modules")) {
            this.processLoginModules(context, node.get("login-modules"), (BaseAuthenticationInfo)authenticationInfo, new LoginModuleContainer(){

                @Override
                public void addAppConfigurationEntry(AppConfigurationEntry entry) {
                    authenticationInfo.add((Object)entry);
                }
            });
        }
        applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        return true;
    }

    private void processLoginModules(OperationContext context, ModelNode node, BaseAuthenticationInfo authInfo, LoginModuleContainer container) throws OperationFailedException {
        List modules = node.asList();
        for (ModelNode module : modules) {
            String codeName = this.extractCode(module, ModulesMap.AUTHENTICATION_MAP);
            AppConfigurationEntry.LoginModuleControlFlag controlFlag = this.getControlFlag(module.require("flag").asString());
            Map<String, Object> options = this.extractOptions(context, module);
            AppConfigurationEntry entry = new AppConfigurationEntry(codeName, controlFlag, options);
            container.addAppConfigurationEntry(entry);
            String moduleName = module.get("module").asString();
            if (!module.hasDefined("module") || moduleName == null || moduleName.length() <= 0) continue;
            authInfo.setJBossModuleName(moduleName);
        }
    }

    private Map<String, Object> extractOptions(OperationContext context, ModelNode module) throws OperationFailedException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (module.hasDefined("module-options")) {
            for (Property prop : module.get("module-options").asPropertyList()) {
                options.put(prop.getName(), context.resolveExpressions(prop.getValue()).asString());
            }
        }
        return options;
    }

    private JSSESecurityDomain createJSSESecurityDomain(OperationContext context, String securityDomain, ModelNode node) throws OperationFailedException {
        if ((node = this.peek(node, "jsse", "classic")) == null) {
            return null;
        }
        final JBossJSSESecurityDomain jsseSecurityDomain = new JBossJSSESecurityDomain(securityDomain);
        String value = null;
        this.processKeyStore(context, node, "keystore", new KeyStoreConfig(){

            @Override
            public void setKeyStorePassword(String value) throws Exception {
                jsseSecurityDomain.setKeyStorePassword(value);
            }

            @Override
            public void setKeyStoreType(String value) {
                jsseSecurityDomain.setKeyStoreType(value);
            }

            @Override
            public void setKeyStoreURL(String value) throws IOException {
                jsseSecurityDomain.setKeyStoreURL(value);
            }

            @Override
            public void setKeyStoreProvider(String value) {
                jsseSecurityDomain.setKeyStoreProvider(value);
            }

            @Override
            public void setKeyStoreProviderArgument(String value) {
                jsseSecurityDomain.setKeyStoreProviderArgument(value);
            }
        });
        this.processKeyStore(context, node, "truststore", new KeyStoreConfig(){

            @Override
            public void setKeyStorePassword(String value) throws Exception {
                jsseSecurityDomain.setTrustStorePassword(value);
            }

            @Override
            public void setKeyStoreType(String value) {
                jsseSecurityDomain.setTrustStoreType(value);
            }

            @Override
            public void setKeyStoreURL(String value) throws IOException {
                jsseSecurityDomain.setTrustStoreURL(value);
            }

            @Override
            public void setKeyStoreProvider(String value) {
                jsseSecurityDomain.setTrustStoreProvider(value);
            }

            @Override
            public void setKeyStoreProviderArgument(String value) {
                jsseSecurityDomain.setTrustStoreProviderArgument(value);
            }
        });
        this.processKeyManager(context, node, "key-manager", new KeyManagerConfig(){

            @Override
            public void setKeyManagerFactoryAlgorithm(String value) {
                jsseSecurityDomain.setKeyManagerFactoryAlgorithm(value);
            }

            @Override
            public void setKeyManagerFactoryProvider(String value) {
                jsseSecurityDomain.setKeyManagerFactoryProvider(value);
            }
        });
        this.processKeyManager(context, node, "trust-manager", new KeyManagerConfig(){

            @Override
            public void setKeyManagerFactoryAlgorithm(String value) {
                jsseSecurityDomain.setTrustManagerFactoryAlgorithm(value);
            }

            @Override
            public void setKeyManagerFactoryProvider(String value) {
                jsseSecurityDomain.setTrustManagerFactoryProvider(value);
            }
        });
        if (node.hasDefined("client-alias")) {
            value = context.resolveExpressions(node.get("client-alias")).asString();
            jsseSecurityDomain.setClientAlias(value);
        }
        if (node.hasDefined("server-alias")) {
            value = context.resolveExpressions(node.get("server-alias")).asString();
            jsseSecurityDomain.setServerAlias(value);
        }
        if (node.hasDefined("client-auth")) {
            boolean clientAuth = context.resolveExpressions(node.get("client-auth")).asBoolean();
            jsseSecurityDomain.setClientAuth(clientAuth);
        }
        if (node.hasDefined("service-auth-token")) {
            value = context.resolveExpressions(node.get("service-auth-token")).asString();
            try {
                jsseSecurityDomain.setServiceAuthToken(value);
            }
            catch (Exception e) {
                throw SecurityMessages.MESSAGES.runtimeException(e);
            }
        }
        if (node.hasDefined("cipher-suites")) {
            value = context.resolveExpressions(node.get("cipher-suites")).asString();
            jsseSecurityDomain.setCipherSuites(value);
        }
        if (node.hasDefined("protocols")) {
            value = context.resolveExpressions(node.get("protocols")).asString();
            jsseSecurityDomain.setProtocols(value);
        }
        if (node.hasDefined("additional-properties")) {
            Properties properties = new Properties();
            for (Property prop : node.get("additional-properties").asPropertyList()) {
                properties.setProperty(prop.getName(), prop.getValue().asString());
            }
            jsseSecurityDomain.setAdditionalProperties(properties);
        }
        return jsseSecurityDomain;
    }

    private void processKeyStore(OperationContext context, ModelNode node, String name, KeyStoreConfig config) throws OperationFailedException {
        ModelNode value = this.peek(node, name, "password");
        ModelNode type = this.peek(node, name, "type");
        ModelNode url = this.peek(node, name, "url");
        ModelNode provider = this.peek(node, name, "provider");
        ModelNode providerArgument = this.peek(node, name, "provider-argument");
        if (value != null) {
            try {
                config.setKeyStorePassword(context.resolveExpressions(value).asString());
            }
            catch (Exception e) {
                throw SecurityMessages.MESSAGES.runtimeException(e);
            }
        }
        if (type != null) {
            config.setKeyStoreType(context.resolveExpressions(type).asString());
        }
        if (url != null) {
            try {
                config.setKeyStoreURL(context.resolveExpressions(url).asString());
            }
            catch (Exception e) {
                throw SecurityMessages.MESSAGES.runtimeException(e);
            }
        }
        if (provider != null) {
            config.setKeyStoreProvider(context.resolveExpressions(provider).asString());
        }
        if (providerArgument != null) {
            config.setKeyStoreProviderArgument(context.resolveExpressions(providerArgument).asString());
        }
    }

    private void processKeyManager(OperationContext context, ModelNode node, String name, KeyManagerConfig config) throws OperationFailedException {
        ModelNode algorithm = this.peek(node, name, "algorithm");
        ModelNode provider = this.peek(node, name, "provider");
        if (algorithm != null) {
            config.setKeyManagerFactoryAlgorithm(context.resolveExpressions(algorithm).asString());
        }
        if (provider != null) {
            config.setKeyManagerFactoryProvider(context.resolveExpressions(provider).asString());
        }
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        switch (ModuleFlag.valueOf(flag.toUpperCase(Locale.ENGLISH))) {
            case SUFFICIENT: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
            case OPTIONAL: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            case REQUISITE: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
        }
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    static String getAuthenticationCacheType(ModelNode node) {
        String type = null;
        if (node.hasDefined("cache-type")) {
            type = node.get("cache-type").asString();
        }
        return type;
    }

    private static interface KeyManagerConfig {
        public void setKeyManagerFactoryAlgorithm(String var1);

        public void setKeyManagerFactoryProvider(String var1);
    }

    private static interface KeyStoreConfig {
        public void setKeyStorePassword(String var1) throws Exception;

        public void setKeyStoreType(String var1);

        public void setKeyStoreURL(String var1) throws IOException;

        public void setKeyStoreProvider(String var1);

        public void setKeyStoreProviderArgument(String var1);
    }

    private static interface LoginModuleContainer {
        public void addAppConfigurationEntry(AppConfigurationEntry var1);
    }
}

