/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Iterator;
import javax.security.auth.login.LoginException;
import org.jboss.as.security.SecurityLogger;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class RemotingLoginModule
extends AbstractServerLoginModule {
    private static final SecurityLogger log = SecurityLogger.ROOT_LOGGER;
    private Principal identity;

    public boolean login() throws LoginException {
        if (super.login()) {
            log.debug("super.login()==true");
            return true;
        }
        Connection con = RemotingContext.getConnection();
        if (con != null) {
            Principal current;
            UserPrincipal up = null;
            Iterator i$ = con.getPrincipals().iterator();
            if (i$.hasNext() && (current = (Principal)i$.next()) instanceof UserPrincipal) {
                up = (UserPrincipal)current;
            }
            if (up != null) {
                this.identity = up;
                if (this.getUseFirstPass()) {
                    String userName = this.identity.getName();
                    if (log.isDebugEnabled()) {
                        log.debug("Storing username '" + userName + "' and empty password");
                    }
                    this.sharedState.put("javax.security.auth.login.name", this.identity);
                    this.sharedState.put("javax.security.auth.login.password", "");
                }
                this.loginOk = true;
                return true;
            }
            throw SecurityMessages.MESSAGES.remotingConnectionWithNoUserPrincipal();
        }
        return false;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        Group[] groups = new Group[]{roles, callerPrincipal};
        callerPrincipal.addMember(this.getIdentity());
        return groups;
    }
}

