/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.security.plugins.PBEUtils;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultFactory;

public final class VaultSession {
    public static final String VAULT_ENC_ALGORITHM = "PBEwithMD5andDES";
    static final Charset CHARSET = Charset.forName("UTF-8");
    private String keystoreURL;
    private String keystorePassword;
    private String keystoreMaskedPassword;
    private String encryptionDirectory;
    private String salt;
    private int iterationCount;
    private SecurityVault vault;
    private String vaultAlias;
    private byte[] handshakeKey;

    public VaultSession(String keystoreURL, String keystorePassword, String encryptionDirectory, String salt, int iterationCount) throws Exception {
        this.keystoreURL = keystoreURL;
        this.keystorePassword = keystorePassword;
        this.encryptionDirectory = encryptionDirectory;
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.validate();
    }

    private void validate() throws Exception {
        this.validateKeystoreURL();
        this.validateEncryptionDirectory();
        this.validateSalt();
        this.validateIterationCount();
        this.validateKeystorePassword();
    }

    protected void validateKeystoreURL() throws Exception {
        File f = new File(this.keystoreURL);
        if (!f.exists()) {
            throw new Exception("Keystore [" + this.keystoreURL + "] doesn't exist." + "\nkeystore could be created: keytool -genkey -alias vault -keyalg RSA -keysize 1024  -keystore " + this.keystoreURL);
        }
        if (!f.canWrite() || !f.isFile()) {
            throw new Exception("Keystore [" + this.keystoreURL + "] is not writable or not a file.");
        }
    }

    protected void validateKeystorePassword() throws Exception {
        if (this.keystorePassword == null) {
            throw new Exception("Keystore password has to be specified.");
        }
    }

    protected void validateEncryptionDirectory() throws Exception {
        File d;
        if (this.encryptionDirectory == null) {
            throw new Exception("Encryption directory has to be specified.");
        }
        if (!this.encryptionDirectory.endsWith("/") || this.encryptionDirectory.endsWith("\\")) {
            this.encryptionDirectory = this.encryptionDirectory + System.getProperty("file.separator", "/");
        }
        if (!(d = new File(this.encryptionDirectory)).exists() && !d.mkdirs()) {
            throw new Exception("Cannot create encryption directory " + d.getAbsolutePath());
        }
        if (!d.isDirectory()) {
            throw new Exception("Encryption directory is not a directory or doesn't exist. (" + this.encryptionDirectory + ")");
        }
    }

    protected void validateIterationCount() throws Exception {
        if (this.iterationCount < 1 && this.iterationCount > Integer.MAX_VALUE) {
            throw new Exception("Iteration count has to be withing 1 - 2147483647, but is " + this.iterationCount + ".");
        }
    }

    protected void validateSalt() throws Exception {
        if (this.salt == null || this.salt.length() != 8) {
            throw new Exception("Salt has to be exactly 8 characters long.");
        }
    }

    private String computeMaskedPassword() throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(VAULT_ENC_ALGORITHM);
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(this.salt.getBytes(), this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        String maskedPass = PBEUtils.encode64((byte[])this.keystorePassword.getBytes(), (String)VAULT_ENC_ALGORITHM, (SecretKey)cipherKey, (PBEParameterSpec)cipherSpec);
        return "MASK-" + maskedPass;
    }

    private void initSecurityVault() throws Exception {
        try {
            this.vault = SecurityVaultFactory.get();
            this.vault.init(this.getVaultOptionsMap());
            this.handshake();
        }
        catch (SecurityVaultException e) {
            throw new Exception("Exception encountered:" + e.getLocalizedMessage(), e);
        }
    }

    public void startVaultSession(String vaultAlias) throws Exception {
        if (vaultAlias == null) {
            throw new Exception("Vault alias has to be specified.");
        }
        this.keystoreMaskedPassword = this.computeMaskedPassword();
        this.vaultAlias = vaultAlias;
        this.initSecurityVault();
    }

    private Map<String, Object> getVaultOptionsMap() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("KEYSTORE_URL", this.keystoreURL);
        options.put("KEYSTORE_PASSWORD", this.keystoreMaskedPassword);
        options.put("KEYSTORE_ALIAS", this.vaultAlias);
        options.put("SALT", this.salt);
        options.put("ITERATION_COUNT", Integer.toString(this.iterationCount));
        options.put("ENC_FILE_DIR", this.encryptionDirectory);
        return options;
    }

    private void handshake() throws SecurityVaultException {
        HashMap<String, String> handshakeOptions = new HashMap<String, String>();
        handshakeOptions.put("PUBLIC_CERT", this.vaultAlias);
        this.handshakeKey = this.vault.handshake(handshakeOptions);
    }

    public void addSecuredAttribute(String vaultBlock, String attributeName, char[] attributeValue) throws Exception {
        if (this.handshakeKey == null) {
            throw new Exception("addSecuredAttribute method has to be called after successful startVaultSession() call.");
        }
        this.vault.store(vaultBlock, attributeName, attributeValue, this.handshakeKey);
        this.attributeCreatedDisplay(vaultBlock, attributeName);
    }

    public boolean checkSecuredAttribute(String vaultBlock, String attributeName) throws Exception {
        if (this.handshakeKey == null) {
            throw new Exception("checkSecuredAttribute method has to be called after successful startVaultSession() call.");
        }
        return this.vault.exists(vaultBlock, attributeName);
    }

    private void attributeCreatedDisplay(String vaultBlock, String attributeName) {
        String keyAsString = new String(this.handshakeKey, CHARSET);
        System.out.println("Secured attribute value has been stored in vault. ");
        System.out.println("Please make note of the following:");
        System.out.println("********************************************");
        System.out.println("Vault Block:" + vaultBlock);
        System.out.println("Attribute Name:" + attributeName);
        System.out.println("Shared Key:" + keyAsString);
        System.out.println("Configuration should be done as follows:");
        System.out.println("VAULT::" + vaultBlock + "::" + attributeName + "::" + keyAsString);
        System.out.println("********************************************");
    }

    public void vaultConfigurationDisplay() {
        System.out.println("Vault Configuration in AS7 config file:");
        System.out.println("********************************************");
        System.out.println("...");
        System.out.println("</extensions>");
        System.out.println("<vault>");
        System.out.println("  <vault-option name=\"KEYSTORE_URL\" value=\"" + this.keystoreURL + "\"/>");
        System.out.println("  <vault-option name=\"KEYSTORE_PASSWORD\" value=\"" + this.keystoreMaskedPassword + "\"/>");
        System.out.println("  <vault-option name=\"KEYSTORE_ALIAS\" value=\"" + this.vaultAlias + "\"/>");
        System.out.println("  <vault-option name=\"SALT\" value=\"" + this.salt + "\"/>");
        System.out.println("  <vault-option name=\"ITERATION_COUNT\" value=\"" + this.iterationCount + "\"/>");
        System.out.println("  <vault-option name=\"ENC_FILE_DIR\" value=\"" + this.encryptionDirectory + "\"/>");
        System.out.println("</vault>");
        System.out.println("<management> ...");
        System.out.println("********************************************");
    }
}

