/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wsc11;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.webservices11.wscoor.client.WSCOORClient;
import com.arjuna.wsc.CannotRegisterException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc.InvalidStateException;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterResponseType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationPortType;

public class RegistrationCoordinator {
    public static W3CEndpointReference register(CoordinationContextType coordinationContext, String messageID, W3CEndpointReference participantProtocolService, String protocolIdentifier) throws CannotRegisterException, InvalidProtocolException, InvalidStateException, SoapFault {
        W3CEndpointReference endpointReference = coordinationContext.getRegistrationService();
        try {
            RegisterType registerType = new RegisterType();
            registerType.setProtocolIdentifier(protocolIdentifier);
            registerType.setParticipantProtocolService(participantProtocolService);
            RegistrationPortType port = WSCOORClient.getRegistrationPort(endpointReference, "http://docs.oasis-open.org/ws-tx/wscoor/2006/06/Register", messageID);
            RegisterResponseType response = port.registerOperation(registerType);
            return response.getCoordinatorProtocolService();
        }
        catch (SOAPFaultException sfe) {
            SOAPFault soapFault = sfe.getFault();
            QName subcode = soapFault.getFaultCodeAsQName();
            if (CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME.equals(subcode)) {
                Detail detail = soapFault.getDetail();
                String message = detail != null ? detail.getTextContent() : soapFault.getFaultString();
                throw new CannotRegisterException(message);
            }
            if (CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PROTOCOL_QNAME.equals(subcode)) {
                Detail detail = soapFault.getDetail();
                String message = detail != null ? detail.getTextContent() : soapFault.getFaultString();
                throw new InvalidProtocolException(message);
            }
            if (CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME.equals(subcode)) {
                Detail detail = soapFault.getDetail();
                String message = detail != null ? detail.getTextContent() : soapFault.getFaultString();
                throw new InvalidStateException(message);
            }
            throw SoapFault11.create(sfe);
        }
    }
}

