/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.NamespaceContextInterceptor;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class NamespaceConfigurator
implements ComponentConfigurator {
    @Override
    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        final ComponentNamingMode namingMode = description.getNamingMode();
        InjectedEENamespaceContextSelector selector = new InjectedEENamespaceContextSelector();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String compName = configuration.getComponentName();
        final ServiceName appContextServiceName = ContextNames.contextServiceNameOfApplication((String)applicationName);
        final ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)applicationName, (String)moduleName);
        final ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)applicationName, (String)moduleName, (String)compName);
        final Injector<NamingStore> appInjector = selector.getAppContextInjector();
        final Injector<NamingStore> moduleInjector = selector.getModuleContextInjector();
        final Injector<NamingStore> compInjector = selector.getCompContextInjector();
        final Injector<NamingStore> jbossInjector = selector.getJbossContextInjector();
        final Injector<NamingStore> globalInjector = selector.getGlobalContextInjector();
        final Injector<NamingStore> exportedInjector = selector.getExportedContextInjector();
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            @Override
            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) {
                serviceBuilder.addDependency(appContextServiceName, NamingStore.class, appInjector);
                serviceBuilder.addDependency(moduleContextServiceName, NamingStore.class, moduleInjector);
                if (namingMode == ComponentNamingMode.CREATE) {
                    serviceBuilder.addDependency(compContextServiceName, NamingStore.class, compInjector);
                } else if (namingMode == ComponentNamingMode.USE_MODULE) {
                    serviceBuilder.addDependency(moduleContextServiceName, NamingStore.class, compInjector);
                }
                serviceBuilder.addDependency(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, NamingStore.class, globalInjector);
                serviceBuilder.addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, NamingStore.class, jbossInjector);
                serviceBuilder.addDependency(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, NamingStore.class, exportedInjector);
            }
        });
        ImmediateInterceptorFactory interceptorFactory = new ImmediateInterceptorFactory((Interceptor)new NamespaceContextInterceptor(selector, context.getServiceTarget()));
        configuration.addPostConstructInterceptor((InterceptorFactory)interceptorFactory, 1280);
        configuration.addPreDestroyInterceptor((InterceptorFactory)interceptorFactory, 1024);
        if (description.isPassivationApplicable()) {
            configuration.addPrePassivateInterceptor((InterceptorFactory)interceptorFactory, 1024);
            configuration.addPostActivateInterceptor((InterceptorFactory)interceptorFactory, 1024);
        }
        configuration.setNamespaceContextInterceptorFactory((InterceptorFactory)interceptorFactory);
        configuration.setNamespaceContextSelector(selector);
    }
}

