/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JacORBLogFormatter
extends Formatter {
    private static final DateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public String format(LogRecord record) {
        long time = record.getMillis();
        String loggerName = record.getLoggerName();
        Level level = record.getLevel();
        String message = record.getMessage();
        Throwable t = record.getThrown();
        StringBuffer result = new StringBuffer();
        result.append(timeFormat.format(new Long(time)));
        result.append(" ");
        result.append(level);
        result.append(" ");
        result.append(message);
        result.append("\n");
        return t == null ? result.toString() : result.toString() + this.getStackTrace(t);
    }

    private String getStackTrace(Throwable t) {
        StringBuffer result = new StringBuffer();
        StackTraceElement[] elements = t.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            result.append("    ");
            result.append(elements[i].toString());
            result.append("\n");
        }
        return result.toString();
    }
}

