/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInternalInputBuffer;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class InternalNioInputBuffer
extends AbstractInternalInputBuffer {
    protected NioChannel channel;
    protected boolean nonBlocking = false;
    protected boolean available = false;
    protected NioEndpoint endpoint = null;
    private CompletionHandler<Integer, NioChannel> completionHandler;

    public InternalNioInputBuffer(Request request, int headerBufferSize, NioEndpoint endpoint) {
        super(request, headerBufferSize);
        this.endpoint = endpoint;
        this.init();
    }

    protected void init() {
        this.inputBuffer = new InputBufferImpl();
        this.readTimeout = this.endpoint.getSoTimeout() > 0 ? this.endpoint.getSoTimeout() : Integer.MAX_VALUE;
        this.completionHandler = new CompletionHandler<Integer, NioChannel>(){

            @Override
            public void completed(Integer nBytes, NioChannel attachment) {
                if (nBytes < 0) {
                    this.failed((Throwable)new ClosedChannelException(), attachment);
                    return;
                }
                if (nBytes > 0) {
                    InternalNioInputBuffer.this.bbuf.flip();
                    InternalNioInputBuffer.this.bbuf.get(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, nBytes);
                    InternalNioInputBuffer.this.lastValid = InternalNioInputBuffer.this.pos + nBytes;
                    InternalNioInputBuffer.this.endpoint.processChannel(attachment, SocketStatus.OPEN_READ);
                }
            }

            @Override
            public void failed(Throwable exc, NioChannel attachment) {
                InternalNioInputBuffer.this.endpoint.removeEventChannel(attachment);
                InternalNioInputBuffer.this.endpoint.processChannel(attachment, SocketStatus.ERROR);
            }
        };
    }

    public void setChannel(NioChannel channel) {
        this.channel = channel;
    }

    public NioChannel getChannel() {
        return this.channel;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public boolean getNonBlocking() {
        return this.nonBlocking;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.bbuf.clear();
        this.channel = null;
        this.available = false;
    }

    @Override
    public boolean nextRequest() {
        boolean result = super.nextRequest();
        this.nonBlocking = false;
        this.available = false;
        return result;
    }

    public boolean parseRequestLine(boolean useAvailableData) throws IOException {
        int start = 0;
        byte chr = 0;
        do {
            if (this.pos < this.lastValid) continue;
            if (useAvailableData) {
                return false;
            }
            if (this.fill()) continue;
            throw new EOFException(CoyoteMessages.MESSAGES.eofError());
        } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
        --this.pos;
        start = this.pos;
        if (this.pos >= this.lastValid) {
            if (useAvailableData) {
                return false;
            }
            if (!this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
        }
        boolean space = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                this.request.method().setBytes(this.buf, start, this.pos - start);
            }
            ++this.pos;
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                eol = true;
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 63 && questionPos == -1) {
                questionPos = this.pos;
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, start, end - start);
        if (questionPos >= 0) {
            this.request.queryString().setBytes(this.buf, questionPos + 1, end - questionPos - 1);
            this.request.requestURI().setBytes(this.buf, start, questionPos - start);
        } else {
            this.request.requestURI().setBytes(this.buf, start, end - start);
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        end = 0;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 13) {
                end = this.pos;
            } else if (this.buf[this.pos] == 10) {
                if (end == 0) {
                    end = this.pos;
                }
                eol = true;
            }
            ++this.pos;
        }
        if (end - start > 0) {
            this.request.protocol().setBytes(this.buf, start, end - start);
        } else {
            this.request.protocol().setString("");
        }
        return true;
    }

    public void useAvailable() {
        this.available = true;
    }

    public boolean available() {
        return this.lastValid - this.pos > 0;
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        return this.lastActiveFilter == -1 ? this.inputBuffer.doRead(chunk, req) : this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }

    @Override
    protected boolean fill() throws IOException {
        int nRead = 0;
        this.prepare();
        if (this.nonBlocking) {
            this.nonBlockingRead(this.bbuf, this.readTimeout, unit);
        } else {
            nRead = this.blockingRead(this.bbuf, this.readTimeout, unit);
            if (nRead > 0) {
                this.bbuf.flip();
                this.bbuf.get(this.buf, this.pos, nRead);
                this.lastValid = this.pos + nRead;
            } else {
                if (nRead == -1) {
                    throw new IOException(CoyoteMessages.MESSAGES.failedRead());
                }
                if (nRead == -2) {
                    throw new SocketTimeoutException(CoyoteMessages.MESSAGES.failedRead());
                }
            }
        }
        return nRead >= 0;
    }

    private void prepare() {
        this.bbuf.clear();
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IllegalArgumentException(CoyoteMessages.MESSAGES.requestHeaderTooLarge());
            }
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
        }
    }

    private void close(NioChannel channel) {
        this.endpoint.closeChannel(channel);
    }

    private void nonBlockingRead(ByteBuffer bb, long timeout, TimeUnit unit) {
        block2: {
            NioChannel ch = this.channel;
            try {
                ch.read(bb, ch, this.completionHandler);
            }
            catch (Throwable t) {
                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block2;
                CoyoteLogger.HTTP_LOGGER.errorWithNonBlockingRead(t);
            }
        }
    }

    protected void readAsync() throws IOException {
        this.prepare();
        this.nonBlockingRead(this.bbuf, this.readTimeout, unit);
    }

    private int blockingRead(ByteBuffer bb, long timeout, TimeUnit unit) {
        int nr;
        block3: {
            nr = 0;
            try {
                long readTimeout = timeout > 0L ? timeout : Integer.MAX_VALUE;
                nr = this.channel.readBytes(bb, readTimeout, unit);
                if (nr < 0) {
                    this.close(this.channel);
                }
            }
            catch (Exception e) {
                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block3;
                CoyoteLogger.HTTP_LOGGER.errorWithBlockingRead(e);
            }
        }
        return nr;
    }

    protected class InputBufferImpl
    implements InputBuffer {
        protected InputBufferImpl() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNioInputBuffer.this.pos >= InternalNioInputBuffer.this.lastValid && !InternalNioInputBuffer.this.fill()) {
                return -1;
            }
            int length = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            chunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, length);
            InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
            return length;
        }
    }
}

