/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import org.jboss.jreadline.complete.CompleteOperation;
import org.jboss.jreadline.complete.Completion;
import org.jboss.jreadline.console.Console;
import org.jboss.jreadline.console.ConsoleCommand;
import org.jboss.jreadline.console.ConsoleOutput;
import org.jboss.jreadline.console.settings.Settings;
import org.jboss.jreadline.edit.actions.Operation;
import org.jboss.jreadline.util.ANSI;

public class Example {
    public static void main(String[] args) throws IOException {
        ConsoleOutput line;
        Settings.getInstance().setReadInputrc(false);
        Console exampleConsole = new Console();
        ConsoleCommand test = new ConsoleCommand(exampleConsole){

            @Override
            protected void afterAttach() throws IOException {
                if (!this.hasRedirectOut()) {
                    this.console.pushToStdOut(ANSI.getAlternateBufferScreen());
                }
                this.readFromFile();
                if (this.hasRedirectOut()) {
                    this.detach();
                }
            }

            @Override
            protected void afterDetach() throws IOException {
                if (!this.hasRedirectOut()) {
                    this.console.pushToStdOut(ANSI.getMainBufferScreen());
                }
            }

            private void readFromFile() throws IOException {
                if (this.getConsoleOutput().getStdOut() != null && this.getConsoleOutput().getStdOut().length() > 0) {
                    this.console.pushToStdOut("FROM STDOUT: " + this.getConsoleOutput().getStdOut());
                } else {
                    this.console.pushToStdOut("here should we present some text... press 'q' to quit");
                }
            }

            @Override
            public void processOperation(Operation operation) throws IOException {
                if (operation.getInput()[0] == 113) {
                    this.detach();
                } else if (operation.getInput()[0] == 97) {
                    this.readFromFile();
                }
            }
        };
        Completion completer = new Completion(){

            @Override
            public void complete(CompleteOperation co) {
                ArrayList<String> commands = new ArrayList<String>();
                if (co.getBuffer().equals("fo") || co.getBuffer().equals("foo")) {
                    commands.add("foo");
                    commands.add("foobaa");
                    commands.add("foobar");
                    commands.add("foobaxxxxxx");
                    commands.add("foobbx");
                    commands.add("foobcx");
                    commands.add("foobdx");
                }
                if (co.getBuffer().equals("--")) {
                    commands.add("--help-");
                }
                if (co.getBuffer().startsWith("--help-") || co.getBuffer().startsWith("--help-m")) {
                    commands.add("--help-me");
                }
                if (co.getBuffer().equals("fooba")) {
                    commands.add("foobaa");
                    commands.add("foobar");
                    commands.add("foobaxxxxxx");
                }
                if (co.getBuffer().equals("foobar")) {
                    commands.add("foobar");
                }
                if (co.getBuffer().equals("bar")) {
                    commands.add("bar/");
                }
                if (co.getBuffer().equals("h")) {
                    commands.add("help.history");
                    commands.add("help");
                }
                if (co.getBuffer().equals("help")) {
                    commands.add("help.history");
                    commands.add("help");
                }
                if (co.getBuffer().equals("help.")) {
                    commands.add("help.history");
                }
                if (co.getBuffer().equals("deploy")) {
                    commands.add("deploy /home/blabla/foo/bar/alkdfe/en/to/tre");
                }
                if (co.getBuffer().equals("testing")) {
                    commands.add("testing YAY");
                }
                co.setCompletionCandidates(commands);
            }
        };
        exampleConsole.addCompletion(completer);
        while ((line = exampleConsole.read("[test@foo.bar]~> ")) != null) {
            exampleConsole.pushToStdOut("======>\"" + line.getBuffer() + "\"\n");
            if (line.getBuffer().equalsIgnoreCase("quit") || line.getBuffer().equalsIgnoreCase("exit") || line.getBuffer().equalsIgnoreCase("reset")) break;
            if (line.getBuffer().equalsIgnoreCase("password")) {
                line = exampleConsole.read("password: ", Character.valueOf('\u0000'));
                exampleConsole.pushToStdOut("password typed:" + line + "\n");
            }
            if (line.getBuffer().startsWith("blah")) {
                exampleConsole.pushToStdErr("blah. command not found.\n");
            }
            if (line.getBuffer().equals("clear")) {
                exampleConsole.clear();
            }
            if (!line.getBuffer().startsWith("man")) continue;
            test.attach(line);
        }
        if (line != null && line.getBuffer().equals("reset")) {
            exampleConsole.stop();
            exampleConsole = new Console();
            while ((line = exampleConsole.read("> ")) != null) {
                exampleConsole.pushToStdOut("======>\"" + line + "\"\n");
                if (!line.getBuffer().equalsIgnoreCase("quit") && !line.getBuffer().equalsIgnoreCase("exit") && !line.getBuffer().equalsIgnoreCase("reset")) continue;
            }
        }
        try {
            exampleConsole.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

