/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.jreadline.complete.CompleteOperation;
import org.jboss.jreadline.complete.Completion;
import org.jboss.jreadline.console.Config;
import org.jboss.jreadline.console.settings.Settings;
import org.jboss.jreadline.util.Parser;

public interface Console {
    public void addCompleter(CommandLineCompleter var1);

    public boolean isUseHistory();

    public void setUseHistory(boolean var1);

    public CommandHistory getHistory();

    public void setHistoryFile(File var1);

    public void clearScreen();

    public void printColumns(Collection<String> var1);

    public void print(String var1);

    public void printNewLine();

    public String readLine(String var1);

    public String readLine(String var1, Character var2);

    public static final class Factory {
        public static Console getConsole(CommandContext ctx) throws CliInitializationException {
            return Factory.getConsole(ctx, null, null);
        }

        public static Console getConsole(final CommandContext ctx, InputStream is, OutputStream os) throws CliInitializationException {
            org.jboss.jreadline.console.Console jReadlineConsole = null;
            try {
                jReadlineConsole = new org.jboss.jreadline.console.Console();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            final org.jboss.jreadline.console.Console finalJReadlineConsole = jReadlineConsole;
            return new Console(){
                private CommandContext cmdCtx;
                private org.jboss.jreadline.console.Console console;
                private CommandHistory history;
                {
                    this.cmdCtx = ctx;
                    this.console = finalJReadlineConsole;
                    this.history = new HistoryImpl();
                }

                @Override
                public void addCompleter(final CommandLineCompleter completer) {
                    this.console.addCompletion(new Completion(){

                        @Override
                        public void complete(CompleteOperation co) {
                            int offset = completer.complete(cmdCtx, co.getBuffer(), co.getCursor(), co.getCompletionCandidates());
                            co.setOffset(offset);
                        }
                    });
                }

                @Override
                public boolean isUseHistory() {
                    return !Settings.getInstance().isHistoryDisabled();
                }

                @Override
                public void setUseHistory(boolean useHistory) {
                    Settings.getInstance().setHistoryDisabled(!useHistory);
                }

                @Override
                public CommandHistory getHistory() {
                    return this.history;
                }

                @Override
                public void setHistoryFile(File f) {
                    Settings.getInstance().setHistoryFile(f);
                }

                @Override
                public void clearScreen() {
                    try {
                        this.console.clear();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void printColumns(Collection<String> list) {
                    String[] newList = new String[list.size()];
                    list.toArray(newList);
                    try {
                        this.console.pushToStdOut(Parser.formatDisplayList(newList, this.console.getTerminalHeight(), this.console.getTerminalWidth()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void print(String line) {
                    try {
                        this.console.pushToStdOut(line);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void printNewLine() {
                    try {
                        this.console.pushToStdOut(Config.getLineSeparator());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public String readLine(String prompt) {
                    try {
                        return this.console.read(prompt).getBuffer();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                public String readLine(String prompt, Character mask) {
                    try {
                        return this.console.read(prompt, mask).getBuffer();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                class HistoryImpl
                implements CommandHistory {
                    HistoryImpl() {
                    }

                    @Override
                    public List<String> asList() {
                        return console.getHistory().getAll();
                    }

                    @Override
                    public boolean isUseHistory() {
                        return !Settings.getInstance().isHistoryDisabled();
                    }

                    @Override
                    public void setUseHistory(boolean useHistory) {
                        Settings.getInstance().setHistoryDisabled(!useHistory);
                    }

                    @Override
                    public void clear() {
                        console.getHistory().clear();
                    }

                    @Override
                    public void setMaxSize(int maxSize) {
                        Settings.getInstance().setHistorySize(maxSize);
                    }

                    @Override
                    public int getMaxSize() {
                        return Settings.getInstance().getHistorySize();
                    }
                }
            };
        }
    }
}

