/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResourceDefinition;
import org.jboss.as.controller.extension.ExtensionSubsystemResourceDefinition;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ExtensionResource
implements Resource.ResourceEntry {
    private static final Set<String> CHILD_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("subsystem")));
    private final String moduleName;
    private final ExtensionRegistry extensionRegistry;

    public ExtensionResource(String moduleName, ExtensionRegistry extensionRegistry) {
        assert (moduleName != null) : "moduleName is null";
        assert (extensionRegistry != null) : "extensionRegistry is null";
        this.moduleName = moduleName;
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public PathElement getPathElement() {
        return PathElement.pathElement("extension", this.moduleName);
    }

    @Override
    public ModelNode getModel() {
        ModelNode model = new ModelNode();
        model.get(ExtensionResourceDefinition.MODULE.getName()).set(this.moduleName);
        return model;
    }

    @Override
    public void writeModel(ModelNode newModel) {
    }

    @Override
    public boolean isModelDefined() {
        return true;
    }

    @Override
    public boolean hasChild(PathElement element) {
        return this.getChildrenNames(element.getKey()).contains(element.getValue());
    }

    @Override
    public Resource getChild(PathElement element) {
        Resource result = null;
        if ("subsystem".equals(element.getKey())) {
            SubsystemInformation info;
            Map<String, SubsystemInformation> entry = this.extensionRegistry.getAvailableSubsystems(this.moduleName);
            SubsystemInformation subsystemInformation = info = entry != null ? entry.get(element.getValue()) : null;
            if (info != null) {
                return new SubsystemResource(element.getValue(), info);
            }
        }
        return result;
    }

    @Override
    public Resource requireChild(PathElement element) {
        Resource child = this.getChild(element);
        if (child == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return child;
    }

    @Override
    public boolean hasChildren(String childType) {
        return this.getChildren(childType).size() > 0;
    }

    @Override
    public Resource navigate(PathAddress address) {
        int size = address.size();
        if (size == 0) {
            return this;
        }
        PathElement pe = address.getElement(0);
        Resource child = this.getChild(pe);
        if (child != null) {
            return size == 1 ? child : child.navigate(address.subAddress(1));
        }
        throw new Resource.NoSuchResourceException(pe);
    }

    @Override
    public Set<String> getChildTypes() {
        return CHILD_TYPES;
    }

    @Override
    public Set<String> getChildrenNames(String childType) {
        HashSet<String> result = null;
        if ("subsystem".equals(childType)) {
            Map<String, SubsystemInformation> info = this.extensionRegistry.getAvailableSubsystems(this.moduleName);
            result = info != null ? new HashSet<String>(info.keySet()) : null;
        }
        return result != null ? result : Collections.emptySet();
    }

    @Override
    public Set<Resource.ResourceEntry> getChildren(String childType) {
        HashSet<SubsystemResource> result = null;
        if ("subsystem".equals(childType)) {
            result = new HashSet<SubsystemResource>();
            Map<String, SubsystemInformation> entry = this.extensionRegistry.getAvailableSubsystems(this.moduleName);
            if (entry != null) {
                for (Map.Entry<String, SubsystemInformation> subsys : entry.entrySet()) {
                    result.add(new SubsystemResource(subsys.getKey(), subsys.getValue()));
                }
            }
        }
        return result;
    }

    @Override
    public void registerChild(PathElement address, Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource removeChild(PathElement address) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRuntime() {
        return false;
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public ExtensionResource clone() {
        return new ExtensionResource(this.moduleName, this.extensionRegistry);
    }

    private static class SubsystemResource
    extends PlaceholderResource.PlaceholderResourceEntry {
        private final SubsystemInformation subsystemInformation;

        public SubsystemResource(String name, SubsystemInformation subsystemInformation) {
            super("subsystem", name);
            this.subsystemInformation = subsystemInformation;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            ModelNode majorNode = model.get(ExtensionSubsystemResourceDefinition.MAJOR_VERSION.getName());
            Integer major = this.subsystemInformation.getManagementInterfaceMajorVersion();
            if (major != null) {
                majorNode.set(major);
            }
            ModelNode minorNode = model.get(ExtensionSubsystemResourceDefinition.MINOR_VERSION.getName());
            Integer minor = this.subsystemInformation.getManagementInterfaceMinorVersion();
            if (minor != null) {
                minorNode.set(minor);
            }
            ModelNode microNode = model.get(ExtensionSubsystemResourceDefinition.MICRO_VERSION.getName());
            Integer micro = this.subsystemInformation.getManagementInterfaceMicroVersion();
            if (micro != null) {
                microNode.set(micro);
            }
            ModelNode xmlNode = model.get(ExtensionSubsystemResourceDefinition.XML_NAMESPACES.getName()).setEmptyList();
            List<String> namespaces = this.subsystemInformation.getXMLNamespaces();
            if (namespaces != null) {
                for (String namespace : namespaces) {
                    xmlNode.add(namespace);
                }
            }
            return model;
        }

        @Override
        public boolean isModelDefined() {
            return true;
        }

        @Override
        public PlaceholderResource.PlaceholderResourceEntry clone() {
            return new SubsystemResource(this.getName(), this.subsystemInformation);
        }
    }
}

