/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.SecurityActions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadAttributeHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute", ControllerResolver.getResolver("global")).setParameters(GlobalOperationHandlers.NAME, GlobalOperationHandlers.INCLUDE_DEFAULTS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).build();
    public static final OperationStepHandler INSTANCE = new ReadAttributeHandler();
    private ParametersValidator validator = new ParametersValidator();

    public ReadAttributeHandler() {
        this.validator.registerValidator(GlobalOperationHandlers.NAME.getName(), new StringLengthValidator(1));
        this.validator.registerValidator(GlobalOperationHandlers.INCLUDE_DEFAULTS.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require(GlobalOperationHandlers.NAME.getName()).asString();
        boolean defaults = operation.get(GlobalOperationHandlers.INCLUDE_DEFAULTS.getName()).asBoolean(true);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        AttributeAccess attributeAccess = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (attributeAccess == null) {
            Set<String> children = context.getResourceRegistration().getChildNames(PathAddress.EMPTY_ADDRESS);
            if (children.contains(attributeName)) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.attributeRegisteredOnResource(attributeName, operation.get("address"))));
            }
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ModelNode subModel = resource.getModel();
            if (subModel.hasDefined(attributeName)) {
                ModelNode result = subModel.get(attributeName);
                context.getResult().set(result);
            } else {
                ModelNode nodeDescription = this.getNodeDescription(registry, context, operation);
                if (defaults && nodeDescription.get("attributes").hasDefined(attributeName) && nodeDescription.get("attributes", attributeName).hasDefined("default")) {
                    ModelNode result = nodeDescription.get("attributes", attributeName, "default");
                    context.getResult().set(result);
                } else if (subModel.has(attributeName) || nodeDescription.get("attributes").has(attributeName)) {
                    context.getResult();
                } else {
                    throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownAttribute(attributeName)));
                }
            }
            context.stepCompleted();
        } else if (attributeAccess.getReadHandler() == null) {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ModelNode subModel = resource.getModel();
            if (subModel.hasDefined(attributeName) || !defaults) {
                ModelNode result = subModel.get(attributeName);
                context.getResult().set(result);
            } else {
                ModelNode nodeDescription = this.getNodeDescription(registry, context, operation);
                if (nodeDescription.get("attributes").hasDefined(attributeName) && nodeDescription.get("attributes", attributeName).hasDefined("default")) {
                    ModelNode result = nodeDescription.get("attributes", attributeName, "default");
                    context.getResult().set(result);
                } else {
                    context.getResult();
                }
            }
            context.stepCompleted();
        } else {
            OperationStepHandler handler = attributeAccess.getReadHandler();
            ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(handler.getClass());
            try {
                handler.execute(context, operation);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldTccl);
            }
        }
    }

    private ModelNode getNodeDescription(ImmutableManagementResourceRegistration registry, OperationContext context, ModelNode operation) throws OperationFailedException {
        DescriptionProvider descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS);
        Locale locale = GlobalOperationHandlers.getLocale(context, operation);
        return descriptionProvider.getModelDescription(locale);
    }
}

