/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadResourceDescriptionHandler
implements OperationStepHandler {
    private static final SimpleAttributeDefinition INHERITED = new SimpleAttributeDefinitionBuilder("inherited", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(true)).build();
    private static final SimpleAttributeDefinition OPERATIONS = new SimpleAttributeDefinitionBuilder("operations", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-resource-description", ControllerResolver.getResolver("global")).setParameters(OPERATIONS, INHERITED, GlobalOperationHandlers.RECURSIVE, GlobalOperationHandlers.RECURSIVE_DEPTH, GlobalOperationHandlers.PROXIES, GlobalOperationHandlers.INCLUDE_ALIASES, GlobalOperationHandlers.LOCALE).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).build();
    static final OperationStepHandler INSTANCE = new ReadResourceDescriptionHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public ReadResourceDescriptionHandler() {
        this.validator.registerValidator(GlobalOperationHandlers.RECURSIVE.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(GlobalOperationHandlers.RECURSIVE_DEPTH.getName(), new ModelTypeValidator(ModelType.INT, true));
        this.validator.registerValidator(GlobalOperationHandlers.PROXIES.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(OPERATIONS.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(INHERITED.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(GlobalOperationHandlers.INCLUDE_ALIASES.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        if (address.isMultiTarget()) {
            this.executeMultiTarget(context, operation);
        } else {
            this.doExecute(context, operation);
        }
    }

    private void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String opName = operation.require("operation").asString();
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress(opAddr);
        int recursiveDepth = GlobalOperationHandlers.RECURSIVE_DEPTH.resolveModelAttribute(context, operation).asInt();
        boolean recursive = recursiveDepth > 0 || GlobalOperationHandlers.RECURSIVE.resolveModelAttribute(context, operation).asBoolean();
        boolean proxies = GlobalOperationHandlers.PROXIES.resolveModelAttribute(context, operation).asBoolean();
        boolean ops = OPERATIONS.resolveModelAttribute(context, operation).asBoolean();
        boolean aliases = GlobalOperationHandlers.INCLUDE_ALIASES.resolveModelAttribute(context, operation).asBoolean();
        boolean inheritedOps = INHERITED.resolveModelAttribute(context, operation).asBoolean();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        AliasEntry aliasEntry = registry.getAliasEntry();
        ImmutableManagementResourceRegistration realRegistry = aliasEntry == null ? registry : context.getRootResourceRegistration().getSubModel(aliasEntry.convertToTargetAddress(PathAddress.pathAddress(opAddr)));
        DescriptionProvider descriptionProvider = realRegistry.getModelDescription(PathAddress.EMPTY_ADDRESS);
        Locale locale = GlobalOperationHandlers.getLocale(context, operation);
        ModelNode nodeDescription = descriptionProvider.getModelDescription(locale);
        HashMap operations = new HashMap();
        final HashMap<PathElement, ModelNode> childResources = recursive ? new HashMap<PathElement, ModelNode>() : Collections.emptyMap();
        ReadResourceDescriptionAssemblyHandler assemblyHandler = new ReadResourceDescriptionAssemblyHandler(nodeDescription, operations, childResources);
        context.addStep(assemblyHandler, OperationContext.Stage.IMMEDIATE);
        if (ops) {
            for (Map.Entry entry : realRegistry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, inheritedOps).entrySet()) {
                if (((OperationEntry)entry.getValue()).getType() != OperationEntry.EntryType.PUBLIC || context.getProcessType() == ProcessType.DOMAIN_SERVER && !((OperationEntry)entry.getValue()).getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) continue;
                DescriptionProvider provider = ((OperationEntry)entry.getValue()).getDescriptionProvider();
                operations.put(entry.getKey(), provider.getModelDescription(locale));
            }
        }
        if (nodeDescription.hasDefined("attributes")) {
            for (String string : nodeDescription.require("attributes").keys()) {
                AttributeAccess access = realRegistry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, string);
                AttributeAccess.AccessType accessType = access == null ? AttributeAccess.AccessType.READ_ONLY : access.getAccessType();
                AttributeAccess.Storage storage = access == null ? AttributeAccess.Storage.CONFIGURATION : access.getStorageType();
                ModelNode attrNode = nodeDescription.get("attributes", string);
                String displayedAccessType = context.getProcessType() == ProcessType.DOMAIN_SERVER && storage == AttributeAccess.Storage.CONFIGURATION ? AttributeAccess.AccessType.READ_ONLY.toString() : accessType.toString();
                attrNode.get("access-type").set(displayedAccessType);
                attrNode.get("storage").set(storage.toString());
                if (accessType != AttributeAccess.AccessType.READ_WRITE) continue;
                Set<AttributeAccess.Flag> flags = access.getFlags();
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
                    attrNode.get("restart-required").set("all-services");
                    continue;
                }
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)) {
                    attrNode.get("restart-required").set("resource-services");
                    continue;
                }
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                    attrNode.get("restart-required").set("jvm");
                    continue;
                }
                attrNode.get("restart-required").set("no-services");
            }
        }
        if (recursive) {
            for (PathElement pathElement : realRegistry.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                PathAddress relativeAddr = PathAddress.pathAddress(pathElement);
                ImmutableManagementResourceRegistration childReg = realRegistry.getSubModel(relativeAddr);
                boolean readChild = true;
                if (childReg.isRemote() && !proxies) {
                    readChild = false;
                }
                if (childReg.isAlias() && !aliases) {
                    readChild = false;
                }
                if (readChild) {
                    int newDepth = recursiveDepth > 0 ? recursiveDepth - 1 : 0;
                    ModelNode rrOp = new ModelNode();
                    rrOp.get("operation").set(opName);
                    try {
                        rrOp.get("address").set(PathAddress.pathAddress(address, pathElement).toModelNode());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    rrOp.get(GlobalOperationHandlers.RECURSIVE.getName()).set(operation.get(GlobalOperationHandlers.RECURSIVE.getName()));
                    rrOp.get(GlobalOperationHandlers.RECURSIVE_DEPTH.getName()).set(newDepth);
                    rrOp.get(GlobalOperationHandlers.PROXIES.getName()).set(proxies);
                    rrOp.get(OPERATIONS.getName()).set(ops);
                    rrOp.get(INHERITED.getName()).set(inheritedOps);
                    rrOp.get(GlobalOperationHandlers.LOCALE.getName()).set(operation.get(GlobalOperationHandlers.LOCALE.getName()));
                    rrOp.get(GlobalOperationHandlers.INCLUDE_ALIASES.getName()).set(aliases);
                    ModelNode rrRsp = new ModelNode();
                    childResources.put(pathElement, rrRsp);
                    OperationStepHandler handler = childReg.isRemote() ? childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName) : new OperationStepHandler(){

                        @Override
                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            ReadResourceDescriptionHandler.this.doExecute(context, operation);
                        }
                    };
                    context.addStep(rrRsp, rrOp, handler, OperationContext.Stage.IMMEDIATE);
                }
                nodeDescription.get("children", pathElement.getKey(), "model-description", pathElement.getValue());
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    for (ModelNode value : childResources.values()) {
                        if (!value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        break;
                    }
                }
            }
        });
    }

    private void executeMultiTarget(OperationContext context, ModelNode operation) {
        final ModelNode result = context.getResult().setEmptyList();
        context.addStep(new ModelNode(), GlobalOperationHandlers.AbstractMultiTargetHandler.FAKE_OPERATION.clone(), new GlobalOperationHandlers.RegistrationAddressResolver(operation, result, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ReadResourceDescriptionHandler.this.doExecute(context, operation);
            }
        }), OperationContext.Stage.IMMEDIATE);
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    String op = operation.require("operation").asString();
                    HashMap<PathAddress, ModelNode> failures = new HashMap<PathAddress, ModelNode>();
                    for (ModelNode resultItem : result.asList()) {
                        if (!resultItem.hasDefined("failure-description")) continue;
                        PathAddress failedAddress = PathAddress.pathAddress(operation.require("address"));
                        ModelNode failedDesc = resultItem.get("failure-description");
                        failures.put(failedAddress, failedDesc);
                    }
                    if (failures.size() == 1) {
                        Map.Entry entry = failures.entrySet().iterator().next();
                        if (((ModelNode)entry.getValue()).getType() == ModelType.STRING) {
                            context.getFailureDescription().set(ControllerMessages.MESSAGES.wildcardOperationFailedAtSingleAddress(op, (PathAddress)entry.getKey(), ((ModelNode)entry.getValue()).asString()));
                        } else {
                            context.getFailureDescription().set(ControllerMessages.MESSAGES.wildcardOperationFailedAtSingleAddressWithComplexFailure(op, (PathAddress)entry.getKey()));
                        }
                    } else if (failures.size() > 1) {
                        context.getFailureDescription().set(ControllerMessages.MESSAGES.wildcardOperationFailedAtMultipleAddresses(op, failures.keySet()));
                    }
                }
            }
        });
    }

    private static class ReadResourceDescriptionAssemblyHandler
    implements OperationStepHandler {
        private final ModelNode nodeDescription;
        private final Map<String, ModelNode> operations;
        private final Map<PathElement, ModelNode> childResources;

        private ReadResourceDescriptionAssemblyHandler(ModelNode nodeDescription, Map<String, ModelNode> operations, Map<PathElement, ModelNode> childResources) {
            this.nodeDescription = nodeDescription;
            this.operations = operations;
            this.childResources = childResources;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (Map.Entry<PathElement, ModelNode> entry : this.childResources.entrySet()) {
                PathElement element = entry.getKey();
                ModelNode value = entry.getValue();
                if (!value.has("failure-description")) {
                    this.nodeDescription.get("children", element.getKey(), "model-description", element.getValue()).set(value.get("result"));
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                break;
            }
            for (Map.Entry<Object, ModelNode> entry : this.operations.entrySet()) {
                this.nodeDescription.get(OPERATIONS.getName(), (String)entry.getKey()).set(entry.getValue());
            }
            context.getResult().set(this.nodeDescription);
            context.stepCompleted();
        }
    }
}

