/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedOutputStream;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

public abstract class AbstractFilePersistenceResource
implements ConfigurationPersister.PersistenceResource {
    private volatile ExposedByteArrayOutputStream marshalled = new ExposedByteArrayOutputStream(8192);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractFilePersistenceResource(ModelNode model, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        try {
            try {
                BufferedOutputStream output = new BufferedOutputStream(this.marshalled);
                persister.marshallAsXml(model, output);
                output.close();
                this.marshalled.close();
            }
            finally {
                IoUtils.safeClose(this.marshalled);
            }
        }
        catch (Exception e) {
            throw ControllerMessages.MESSAGES.failedToMarshalConfiguration(e);
        }
    }

    @Override
    public void commit() {
        if (this.marshalled == null) {
            throw ControllerMessages.MESSAGES.rollbackAlreadyInvoked();
        }
        this.doCommit(this.marshalled);
    }

    @Override
    public void rollback() {
        this.marshalled = null;
    }

    protected abstract void doCommit(ExposedByteArrayOutputStream var1);
}

