/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.FilePersistenceUtils;

public class ConfigurationFile {
    private static final String LAST = "last";
    private static final String INITIAL = "initial";
    private static final String BOOT = "boot";
    private static final String LAST_SUFFIX = "last.xml";
    private static final String INITIAL_SUFFIX = "initial.xml";
    private static final String ORIGINAL_SUFFIX = "boot.xml";
    private static final int CURRENT_HISTORY_LENGTH = 100;
    private static final int HISTORY_DAYS = 30;
    private static final String TIMESTAMP_STRING = "\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\d\\d\\d";
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\d\\d\\d");
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmmssSSS";
    private static final Pattern VERSION_PATTERN = Pattern.compile("v\\d+");
    private static final Pattern FILE_WITH_VERSION_PATTERN = Pattern.compile("\\S*\\.v\\d+\\.xml");
    private static final Pattern SNAPSHOT_XML = Pattern.compile("\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d\\d\\d\\d\\S*\\.xml");
    private final AtomicInteger sequence = new AtomicInteger();
    private final AtomicBoolean doneBootup = new AtomicBoolean();
    private final File configurationDir;
    private final String rawFileName;
    private final String bootFileName;
    private volatile File bootFile;
    private volatile boolean reloadUsingLast;
    private final File mainFile;
    private final String mainFileName;
    private final File historyRoot;
    private final File currentHistory;
    private final File snapshotsDirectory;
    private final boolean persistOriginal;
    private volatile File lastFile;

    public ConfigurationFile(File configurationDir, String rawName, String name, boolean persistOriginal) {
        if (!configurationDir.exists() || !configurationDir.isDirectory()) {
            throw ControllerMessages.MESSAGES.directoryNotFound(configurationDir.getAbsolutePath());
        }
        this.rawFileName = rawName;
        this.bootFileName = name != null ? name : rawName;
        this.configurationDir = configurationDir;
        this.historyRoot = new File(configurationDir, rawName.replace('.', '_') + "_history");
        this.currentHistory = new File(this.historyRoot, "current");
        this.snapshotsDirectory = new File(this.historyRoot, "snapshot");
        this.persistOriginal = persistOriginal;
        File file = this.determineMainFile(configurationDir, rawName, name);
        try {
            this.mainFile = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw ControllerMessages.MESSAGES.canonicalMainFileNotFound(ioe, file);
        }
        this.mainFileName = this.mainFile.getName();
    }

    public synchronized void resetBootFile(boolean reloadUsingLast) {
        this.bootFile = null;
        this.reloadUsingLast = reloadUsingLast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getBootFile() {
        if (this.bootFile == null) {
            ConfigurationFile configurationFile = this;
            synchronized (configurationFile) {
                if (this.bootFile == null) {
                    String bootFileName = this.bootFileName;
                    if (!this.persistOriginal && this.reloadUsingLast) {
                        bootFileName = LAST;
                    }
                    if (bootFileName.equals(this.rawFileName)) {
                        this.bootFile = this.mainFile;
                    } else {
                        this.bootFile = this.determineBootFile(this.configurationDir, bootFileName);
                        try {
                            this.bootFile = this.bootFile.getCanonicalFile();
                        }
                        catch (IOException ioe) {
                            throw ControllerMessages.MESSAGES.canonicalBootFileNotFound(ioe, this.bootFile);
                        }
                    }
                }
            }
        }
        return this.bootFile;
    }

    private File determineMainFile(File configurationDir, String rawName, String name) {
        String mainName = null;
        if (name == null) {
            mainName = rawName;
        } else if (name.equals(LAST) || name.equals(INITIAL) || name.equals(BOOT)) {
            mainName = this.findMainFileFromBackupSuffix(this.historyRoot, name);
        } else if (VERSION_PATTERN.matcher(name).matches()) {
            mainName = this.findMainFileFromBackupSuffix(this.currentHistory, name);
        }
        if (mainName == null) {
            mainName = this.findMainFileFromSnapshotPrefix(name);
        }
        if (mainName == null) {
            File absoluteFile;
            File directoryFile = new File(configurationDir, name);
            if (directoryFile.exists()) {
                mainName = this.stripPrefixSuffix(name);
            } else if (!this.persistOriginal && (absoluteFile = new File(name)).exists()) {
                return absoluteFile;
            }
        }
        if (mainName != null) {
            return new File(configurationDir, new File(mainName).getName());
        }
        throw ControllerMessages.MESSAGES.mainFileNotFound(name != null ? name : rawName, configurationDir);
    }

    private String findMainFileFromBackupSuffix(File searchDir, String backupType) {
        final String suffix = "." + backupType + ".xml";
        File[] files = null;
        if (searchDir.exists() && searchDir.isDirectory()) {
            files = searchDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffix);
                }
            });
        }
        if (files == null || files.length == 0) {
            throw ControllerMessages.MESSAGES.configurationFileNotFound(suffix, searchDir);
        }
        if (files.length > 1) {
            throw ControllerMessages.MESSAGES.ambiguousConfigurationFiles(backupType, searchDir, suffix);
        }
        String matchName = files[0].getName();
        if (matchName.equals(suffix)) {
            throw ControllerMessages.MESSAGES.configurationFileNameNotAllowed(backupType);
        }
        String prefix = matchName.substring(0, matchName.length() - suffix.length());
        return prefix + ".xml";
    }

    private String findMainFileFromSnapshotPrefix(final String prefix) {
        File[] files = null;
        if (this.snapshotsDirectory.exists() && this.snapshotsDirectory.isDirectory()) {
            files = this.snapshotsDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
        }
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length > 1) {
            throw ControllerMessages.MESSAGES.ambiguousConfigurationFiles(prefix, this.snapshotsDirectory, prefix);
        }
        String matchName = files[0].getName();
        return matchName.substring(TIMESTAMP_FORMAT.length());
    }

    private String stripPrefixSuffix(String name) {
        if (SNAPSHOT_XML.matcher(name).matches()) {
            name = name.substring(TIMESTAMP_FORMAT.length());
        }
        if (FILE_WITH_VERSION_PATTERN.matcher(name).matches()) {
            int last = name.lastIndexOf(118);
            name = name.substring(0, last) + "xml";
        } else if (name.endsWith(LAST_SUFFIX)) {
            name = name.substring(0, name.length() - LAST_SUFFIX.length()) + "xml";
        } else if (name.endsWith(ORIGINAL_SUFFIX)) {
            name = name.substring(0, name.length() - ORIGINAL_SUFFIX.length()) + "xml";
        } else if (name.endsWith(INITIAL_SUFFIX)) {
            name = name.substring(0, name.length() - INITIAL_SUFFIX.length()) + "xml";
        }
        return name;
    }

    private File determineBootFile(File configurationDir, String name) {
        File absoluteFile;
        File versioned;
        if (name.equals(LAST) || name.equals(INITIAL) || name.equals(BOOT)) {
            return this.addSuffixToFile(new File(this.historyRoot, this.mainFile.getName()), name);
        }
        if (VERSION_PATTERN.matcher(name).matches() && (versioned = this.getVersionedFile(this.mainFile, name)).exists()) {
            return versioned;
        }
        File snapshot = this.findSnapshotWithPrefix(name, false);
        if (snapshot != null) {
            return snapshot;
        }
        File directoryFile = new File(configurationDir, name);
        if (directoryFile.exists()) {
            return directoryFile;
        }
        if (!this.persistOriginal && (absoluteFile = new File(name)).exists()) {
            return absoluteFile;
        }
        throw ControllerMessages.MESSAGES.fileNotFound(directoryFile.getAbsolutePath());
    }

    File getMainFile() {
        return this.mainFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void successfulBoot() throws ConfigurationPersistenceException {
        ConfigurationFile configurationFile = this;
        synchronized (configurationFile) {
            File copySource;
            if (this.doneBootup.get()) {
                return;
            }
            if (this.persistOriginal) {
                copySource = this.mainFile;
            } else {
                copySource = new File(this.mainFile.getParentFile(), this.mainFile.getName() + ".boot");
                FilePersistenceUtils.deleteFile(copySource);
                copySource.deleteOnExit();
            }
            try {
                if (!this.bootFile.equals(copySource)) {
                    FilePersistenceUtils.copyFile(this.bootFile, copySource);
                }
                this.createHistoryDirectory();
                File historyBase = new File(this.historyRoot, this.mainFile.getName());
                this.lastFile = this.addSuffixToFile(historyBase, LAST);
                File boot = this.addSuffixToFile(historyBase, BOOT);
                File initial = this.addSuffixToFile(historyBase, INITIAL);
                if (!initial.exists()) {
                    FilePersistenceUtils.copyFile(copySource, initial);
                }
                FilePersistenceUtils.copyFile(copySource, this.lastFile);
                FilePersistenceUtils.copyFile(copySource, boot);
            }
            catch (IOException e) {
                throw ControllerMessages.MESSAGES.failedToCreateConfigurationBackup(e, this.bootFile);
            }
            finally {
                if (!this.persistOriginal) {
                    try {
                        FilePersistenceUtils.deleteFile(copySource);
                    }
                    catch (Exception ignore) {}
                }
            }
            this.doneBootup.set(true);
        }
    }

    void backup() throws ConfigurationPersistenceException {
        if (!this.doneBootup.get()) {
            return;
        }
        try {
            File delete;
            if (this.persistOriginal) {
                this.moveFile(this.mainFile, this.getVersionedFile(this.mainFile));
            } else {
                this.moveFile(this.lastFile, this.getVersionedFile(this.mainFile));
            }
            int seq = this.sequence.get();
            if (seq > 100 && (delete = this.getVersionedFile(this.mainFile, seq - 100)).exists()) {
                delete.delete();
            }
        }
        catch (IOException e) {
            throw ControllerMessages.MESSAGES.failedToBackup(e, this.mainFile);
        }
    }

    void commitTempFile(File temp) throws ConfigurationPersistenceException {
        if (!this.doneBootup.get()) {
            return;
        }
        if (this.persistOriginal) {
            FilePersistenceUtils.moveTempFileToMain(temp, this.mainFile);
        } else {
            FilePersistenceUtils.moveTempFileToMain(temp, this.lastFile);
        }
    }

    void fileWritten() throws ConfigurationPersistenceException {
        if (!this.doneBootup.get() || !this.persistOriginal) {
            return;
        }
        try {
            FilePersistenceUtils.copyFile(this.mainFile, this.lastFile);
        }
        catch (IOException e) {
            throw ControllerMessages.MESSAGES.failedToBackup(e, this.mainFile);
        }
    }

    private void moveFile(File file, File backup) throws IOException {
        if (backup.exists()) {
            backup.delete();
        }
        FilePersistenceUtils.rename(file, backup);
    }

    String snapshot() throws ConfigurationPersistenceException {
        String name = ConfigurationFile.getTimeStamp(new Date()) + this.mainFileName;
        File snapshot = new File(this.snapshotsDirectory, name);
        try {
            FilePersistenceUtils.copyFile(this.mainFile, snapshot);
        }
        catch (IOException e) {
            throw ControllerMessages.MESSAGES.failedToTakeSnapshot(e, this.mainFile, snapshot);
        }
        return snapshot.toString();
    }

    ConfigurationPersister.SnapshotInfo listSnapshots() {
        return new BackupSnapshotInfo();
    }

    void deleteSnapshot(String prefix) {
        if (prefix.equals("all")) {
            if (this.snapshotsDirectory.exists() && this.snapshotsDirectory.isDirectory()) {
                for (String curr : this.snapshotsDirectory.list()) {
                    new File(this.snapshotsDirectory, curr).delete();
                }
            }
        } else {
            this.findSnapshotWithPrefix(prefix, true).delete();
        }
    }

    boolean isPersistOriginal() {
        return this.persistOriginal;
    }

    private File findSnapshotWithPrefix(String prefix, boolean errorIfNoFiles) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.snapshotsDirectory.exists() && this.snapshotsDirectory.isDirectory()) {
            for (String curr : this.snapshotsDirectory.list()) {
                if (!curr.startsWith(prefix)) continue;
                names.add(curr);
            }
        }
        if (names.size() == 0 && errorIfNoFiles) {
            throw ControllerMessages.MESSAGES.fileNotFoundWithPrefix(prefix, this.snapshotsDirectory.getAbsolutePath());
        }
        if (names.size() > 1) {
            throw ControllerMessages.MESSAGES.ambiguousName(prefix, this.snapshotsDirectory.getAbsolutePath(), names);
        }
        return names.size() > 0 ? new File(this.snapshotsDirectory, (String)names.get(0)) : null;
    }

    private void createHistoryDirectory() throws IOException {
        this.mkdir(this.historyRoot);
        this.mkdir(this.snapshotsDirectory);
        if (this.currentHistory.exists()) {
            if (!this.currentHistory.isDirectory()) {
                throw ControllerMessages.MESSAGES.notADirectory(this.currentHistory.getAbsolutePath());
            }
            Date date = new Date();
            if (this.currentHistory.listFiles().length > 0) {
                String backupName = ConfigurationFile.getTimeStamp(date);
                File old = new File(this.historyRoot, backupName);
                if (!new File(this.currentHistory.getAbsolutePath()).renameTo(old)) {
                    throw ControllerMessages.MESSAGES.cannotRename(this.currentHistory.getAbsolutePath(), old.getAbsolutePath());
                }
            }
            String cutoffFileName = ConfigurationFile.getTimeStamp(this.subtractDays(date, 30));
            for (String name : this.historyRoot.list()) {
                if (name.length() != cutoffFileName.length() || !TIMESTAMP_PATTERN.matcher(name).matches() || name.compareTo(cutoffFileName) >= 0) continue;
                this.deleteRecursive(new File(this.historyRoot, name));
            }
        }
        this.currentHistory.mkdir();
        if (!this.currentHistory.exists()) {
            throw ControllerMessages.MESSAGES.cannotCreate(this.currentHistory.getAbsolutePath());
        }
    }

    private void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (String name : file.list()) {
                this.deleteRecursive(new File(file, name));
            }
        }
        if (!file.delete()) {
            throw ControllerMessages.MESSAGES.cannotDelete(file);
        }
    }

    private File getVersionedFile(File file) {
        return this.getVersionedFile(file, this.sequence.incrementAndGet());
    }

    private File getVersionedFile(File file, int i) {
        return this.addSuffixToFile(new File(this.currentHistory, file.getName()), "v" + i);
    }

    private File getVersionedFile(File file, String versionString) {
        return this.addSuffixToFile(new File(this.currentHistory, file.getName()), versionString);
    }

    private File addSuffixToFile(File file, String suffix) {
        String path = file.getAbsolutePath();
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return new File(file.getAbsolutePath() + "." + suffix);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(path.substring(0, index));
        sb.append(".");
        sb.append(suffix);
        sb.append(path.substring(index));
        return new File(sb.toString());
    }

    private Date subtractDays(Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int doy = calendar.get(6);
        calendar.set(6, doy - days);
        return calendar.getTime();
    }

    private static String getTimeStamp(Date date) {
        SimpleDateFormat sfd = new SimpleDateFormat(TIMESTAMP_FORMAT);
        return sfd.format(date);
    }

    private File mkdir(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdir()) {
                throw ControllerMessages.MESSAGES.cannotCreate(this.historyRoot.getAbsolutePath());
            }
        } else if (!dir.isDirectory()) {
            throw ControllerMessages.MESSAGES.notADirectory(dir.getAbsolutePath());
        }
        return dir;
    }

    private class BackupSnapshotInfo
    implements ConfigurationPersister.SnapshotInfo {
        final ArrayList<String> names = new ArrayList();

        public BackupSnapshotInfo() {
            for (String name : ConfigurationFile.this.snapshotsDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return SNAPSHOT_XML.matcher(name).matches();
                }
            })) {
                this.names.add(name);
            }
        }

        @Override
        public String getSnapshotDirectory() {
            return ConfigurationFile.this.snapshotsDirectory.getAbsolutePath();
        }

        @Override
        public List<String> names() {
            return this.names;
        }
    }
}

