/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.File;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.as.controller.persistence.FilePersistenceUtils;
import org.jboss.dmr.ModelNode;

public class ConfigurationFilePersistenceResource
extends AbstractFilePersistenceResource {
    private final ConfigurationFile configurationFile;
    private final File tempFileName;
    protected final File fileName;

    ConfigurationFilePersistenceResource(ModelNode model, ConfigurationFile configurationFile, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.configurationFile = configurationFile;
        this.fileName = configurationFile.getMainFile();
        this.tempFileName = FilePersistenceUtils.createTempFile(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit(ExposedByteArrayOutputStream marshalled) {
        try {
            try {
                FilePersistenceUtils.writeToTempFile(marshalled, this.tempFileName);
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
                return;
            }
            try {
                this.configurationFile.backup();
            }
            finally {
                this.configurationFile.commitTempFile(this.tempFileName);
            }
            this.configurationFile.fileWritten();
        }
        catch (ConfigurationPersistenceException e) {
            ControllerLogger.MGMT_OP_LOGGER.errorf((Throwable)e, e.toString(), new Object[0]);
        }
    }
}

